/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.RecordFactory;

public class MetaFactory {
    private static final MetaFactory SNGL = new MetaFactory();
    private RecordFactory recordFactory = null;
    private Map<String, MetaColumn> map = new ConcurrentHashMap<String, MetaColumn>();

    public static final MetaFactory getInstance() {
        return SNGL;
    }

    private MetaFactory() {
    }

    public void init(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    private MetaColumn createMetaColumn(String table) throws Exception {
        Connection conn = null;
        ResultSet r = null;
        try {
            conn = this.recordFactory.getConnectionManager().getConnection();
            if (conn == null) {
                throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            r = conn.createStatement().executeQuery("select * from " + table);
            ResultSetMetaData meta = r.getMetaData();
            MetaColumn ret = new MetaColumn(table, meta);
            r.close();
            r = null;
            conn.close();
            conn = null;
            MetaColumn metaColumn = ret;
            return metaColumn;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
            r = null;
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean isUse() {
        return this.recordFactory != null;
    }

    public void clear() {
        this.map.clear();
    }

    public MetaColumn getMetaColumn(String table) throws Exception {
        return this.getMetaColumn(false, table);
    }

    public MetaColumn getMetaColumn(boolean mode, String table) throws Exception {
        if (!this.isUse()) {
            throw new MaachangDaoException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u521d\u671f\u5316\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        MetaColumn ret = null;
        if (mode) {
            table = DbUtil.convertJavaNameByDBName(table);
        }
        if ((ret = this.map.get(table)) == null) {
            ret = this.createMetaColumn(table);
            if (ret != null) {
                this.map.put(table, ret);
            } else {
                throw new MaachangDaoException("\u6307\u5b9a\u30c6\u30fc\u30d6\u30eb\u540d[" + table + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
        }
        return ret;
    }
}

