/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.util.FileUtil;

class RecordSequenceMeta {
    private Map<String, Integer> meta = new HashMap<String, Integer>();
    private RandomAccessFile writeRandomFp = null;

    private RecordSequenceMeta() {
    }

    public RecordSequenceMeta(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        RandomAccessFile writeRandomFp = null;
        if (FileUtil.isFileExists((String)name)) {
            this.load(name);
            writeRandomFp = new RandomAccessFile(name, "rwd");
            writeRandomFp.seek(writeRandomFp.length());
        } else {
            writeRandomFp = new RandomAccessFile(name, "rwd");
        }
        this.writeRandomFp = writeRandomFp;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    private void load(String name) throws Exception {
        BufferedReader br = null;
        this.meta.clear();
        try {
            String s;
            br = new BufferedReader(new InputStreamReader(new FileInputStream(name)));
            while ((s = br.readLine()) != null) {
                int p;
                if ((s = s.trim()).length() <= 0 || (p = s.indexOf("=")) <= -1) continue;
                boolean flg = false;
                String key = null;
                Integer value = null;
                try {
                    key = s.substring(0, p);
                    value = new Integer(s.substring(p + 1));
                }
                catch (Exception e) {
                    flg = true;
                }
                if (flg) continue;
                this.meta.put(key, value);
            }
            br.close();
            br = null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            br = null;
        }
    }

    public void destroy() {
        if (this.writeRandomFp != null) {
            try {
                this.writeRandomFp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.meta.clear();
        this.writeRandomFp = null;
    }

    public boolean isUse() {
        return this.writeRandomFp != null;
    }

    public void put(String metaName, int pos) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (metaName == null || metaName.length() <= 0 || pos <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.meta.containsKey(metaName = DbUtil.convertJavaNameByDBName(metaName))) {
            this.writeRandomFp.write((metaName + "=" + pos + "\n").getBytes());
            this.meta.put(metaName, new Integer(pos));
        }
    }

    public int get(String metaName) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (metaName == null || metaName.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Integer ret = this.meta.get(metaName = DbUtil.convertJavaNameByDBName(metaName));
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public boolean containsKey(String metaName) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (metaName == null || metaName.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        metaName = DbUtil.convertJavaNameByDBName(metaName);
        return this.meta.containsKey(metaName);
    }
}

