/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.replication;

import com.y_ys.cluster.ha.MqNetUtil;
import com.y_ys.cluster.ha.MqPacket;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.util.ConvertParam;

public class ReplicationSQL
extends MqPacket {
    public static final int COMMAND_INSERT = 1;
    public static final int COMMAND_UPDATE = 2;
    public static final int COMMAND_DELETE = 3;
    private int command = -1;
    private String tableName = null;
    private String sql = null;
    private Object[] params = null;
    private static final int PARAMS_NULL = 0;
    private static final int PARAMS_BOOL = 1;
    private static final int PARAMS_INTEGER = 2;
    private static final int PARAMS_LONG = 3;
    private static final int PARAMS_DOUBLE = 4;
    private static final int PARAMS_FLOAT = 5;
    private static final int PARAMS_DATE = 10;
    private static final int PARAMS_TIME = 11;
    private static final int PARAMS_TIMESTAMP = 12;
    private static final int PARAMS_STRING = 20;
    private static final int PARAMS_BINARY = 30;

    public ReplicationSQL(long id, long createTime, byte[] bin, int off) throws Exception {
        super(id, createTime, bin, off);
        this.convertBinary(bin, off);
    }

    public ReplicationSQL(int command, String tableName, String sql, Object[] params) throws Exception {
        tableName = DbUtil.convertJavaNameByDBName(tableName);
        if (tableName == null || sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        switch (command) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u30b3\u30de\u30f3\u30c9\u5b9a\u7fa9(" + command + ")\u304c\u4e0d\u6b63\u3067\u3059");
            }
        }
        if (params == null || params.length <= 0) {
            params = null;
        }
        this.command = command;
        this.tableName = tableName;
        this.sql = sql;
        this.params = params;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.destroy();
        this.command = -1;
        this.tableName = null;
        this.sql = null;
        this.params = null;
    }

    public int getType() {
        return 0;
    }

    public String typString() {
        return "DB";
    }

    public int getCommand() {
        return this.command;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSql() {
        return this.sql;
    }

    public Object[] getParams() {
        return this.params;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" command:");
        switch (this.command) {
            case 1: {
                buf.append("insert");
                break;
            }
            case 2: {
                buf.append("update");
                break;
            }
            case 3: {
                buf.append("delete");
                break;
            }
            default: {
                buf.append("unknown");
            }
        }
        buf.append(" table:").append(this.tableName);
        buf.append(" sql:[").append(this.sql).append("]");
        buf.append(" params(");
        if (this.params != null) {
            int len = this.params.length;
            buf.append(len).append("): {");
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                if (this.params[i] == null) {
                    buf.append(" null");
                } else if (this.params[i] instanceof byte[]) {
                    buf.append(" ").append(((byte[])this.params[i]).length).append("@").append("byte[]");
                } else {
                    buf.append(" ").append(this.params[i]).append("@").append(this.params[i].getClass().getName());
                }
                ++i;
            }
            buf.append(" }");
        } else {
            buf.append("0)");
        }
        super.toString(buf);
        return buf.toString();
    }

    protected void getBinary(OutputStream out) throws Exception {
        this.tableName = DbUtil.convertJavaNameByDBName(this.tableName);
        if (this.tableName == null || this.sql == null || (this.sql = this.sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        switch (this.command) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u30b3\u30de\u30f3\u30c9\u5b9a\u7fa9(" + this.command + ")\u304c\u4e0d\u6b63\u3067\u3059");
            }
        }
        if (this.params == null || this.params.length <= 0) {
            this.params = null;
        }
        byte[] b = null;
        out.write(ConvertParam.convertInt((int)this.command));
        b = this.tableName.getBytes("UTF8");
        out.write(ConvertParam.convertInt((int)b.length));
        out.write(b);
        b = this.sql.getBytes("UTF8");
        out.write(ConvertParam.convertInt((int)b.length));
        out.write(b);
        b = null;
        int paramLen = this.params == null ? 0 : this.params.length;
        out.write(ConvertParam.convertInt((int)paramLen));
        int i = 0;
        while (i < paramLen) {
            Object o = this.params[i];
            if (o == null) {
                out.write(0);
            } else if (o instanceof Boolean) {
                out.write(1);
                out.write((Boolean)o != false ? 1 : 0);
            } else if (o instanceof Integer) {
                out.write(2);
                out.write(ConvertParam.convertInt((int)((Integer)o)));
            } else if (o instanceof Long) {
                out.write(3);
                out.write(ConvertParam.convertLong((long)((Long)o)));
            } else if (o instanceof Double) {
                out.write(4);
                out.write(ConvertParam.convertDouble((double)((Double)o)));
            } else if (o instanceof Float) {
                out.write(5);
                out.write(ConvertParam.convertFloat((float)((Float)o).floatValue()));
            } else if (o instanceof Date) {
                out.write(10);
                out.write(ConvertParam.convertLong((long)((Date)o).getTime()));
            } else if (o instanceof Time) {
                out.write(11);
                out.write(ConvertParam.convertLong((long)((Time)o).getTime()));
            } else if (o instanceof Timestamp) {
                out.write(12);
                out.write(ConvertParam.convertLong((long)((Timestamp)o).getTime()));
            } else if (o instanceof String) {
                out.write(20);
                if (((String)o).length() <= 0) {
                    out.write(ConvertParam.convertInt((int)0));
                } else {
                    b = ((String)o).getBytes("UTF8");
                    out.write(ConvertParam.convertInt((int)b.length));
                    out.write(b);
                    b = null;
                }
            } else if (o instanceof byte[]) {
                out.write(30);
                if (((byte[])o).length <= 0) {
                    out.write(ConvertParam.convertInt((int)0));
                } else {
                    out.write(ConvertParam.convertInt((int)((byte[])o).length));
                    out.write((byte[])o);
                }
            } else {
                throw new IOException("\u4e0d\u6b63\u306a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u578b(" + o.getClass().getName() + ")\u3067\u3059");
            }
            ++i;
        }
    }

    protected void convertBinary(byte[] bin, int off) throws Exception {
        int cmd = ConvertParam.convertInt((int)off, (byte[])bin);
        int len = ConvertParam.convertInt((int)(off += 4), (byte[])bin);
        String tblName = new String(bin, off += 4, len, "UTF8");
        off += len;
        len = ConvertParam.convertInt((int)off, (byte[])bin);
        String sql = new String(bin, off += 4, len, "UTF8");
        int paramLen = ConvertParam.convertInt((int)(off += len), (byte[])bin);
        off += 4;
        Object[] pms = null;
        if (paramLen > 0) {
            pms = new Object[paramLen];
            int i = 0;
            while (i < paramLen) {
                int paramType = bin[off] & 0xFF;
                ++off;
                switch (paramType) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        pms[i] = bin[off] == 0 ? Boolean.FALSE : Boolean.TRUE;
                        ++off;
                        break;
                    }
                    case 2: {
                        pms[i] = new Integer(ConvertParam.convertInt((int)off, (byte[])bin));
                        off += 4;
                        break;
                    }
                    case 3: {
                        pms[i] = new Long(ConvertParam.convertLong((int)off, (byte[])bin));
                        off += 8;
                        break;
                    }
                    case 4: {
                        pms[i] = ConvertParam.convertDoubleObject((int)off, (byte[])bin);
                        off += ConvertParam.convertShort((int)off, (byte[])bin) + 2;
                        break;
                    }
                    case 5: {
                        pms[i] = ConvertParam.convertFloatObject((int)off, (byte[])bin);
                        off += ConvertParam.convertShort((int)off, (byte[])bin) + 2;
                        break;
                    }
                    case 10: {
                        pms[i] = new Date(ConvertParam.convertLong((int)off, (byte[])bin));
                        off += 8;
                        break;
                    }
                    case 11: {
                        pms[i] = new Time(ConvertParam.convertLong((int)off, (byte[])bin));
                        off += 8;
                        break;
                    }
                    case 12: {
                        pms[i] = new Timestamp(ConvertParam.convertLong((int)off, (byte[])bin));
                        off += 8;
                        break;
                    }
                    case 20: {
                        len = ConvertParam.convertInt((int)off, (byte[])bin);
                        off += 4;
                        if (len <= 0) {
                            pms[i] = "";
                            break;
                        }
                        pms[i] = new String(bin, off, len, "UTF8");
                        off += len;
                        break;
                    }
                    case 30: {
                        len = ConvertParam.convertInt((int)off, (byte[])bin);
                        off += 4;
                        if (len <= 0) {
                            pms[i] = new byte[0];
                            break;
                        }
                        byte[] b = new byte[len];
                        System.arraycopy(bin, off, b, 0, len);
                        pms[i] = b;
                        off += len;
                        break;
                    }
                    default: {
                        throw new IOException("[" + i + "]:\u30d1\u30e9\u30e1\u30fc\u30bf\u30bf\u30a4\u30d7(" + paramType + ")\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                }
                ++i;
            }
        }
        this.command = cmd;
        this.tableName = tblName;
        this.sql = sql;
        this.params = pms;
    }

    public static final void main(String[] args) throws Exception {
        String tableName = "TestTable";
        String sql = "insert into test_table ( id,name,name_kana,yen,img ) values ( ?,?,?,?,? )";
        Object[] objectArray = new Object[5];
        objectArray[0] = new Long(1L);
        objectArray[1] = "\u7a42\u4e0b\u592a\u90ce";
        objectArray[2] = "\u30db\u30b2\u30bf\u30ed\u30a6";
        objectArray[3] = new Double(100.234f);
        byte[] byArray = new byte[6];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        objectArray[4] = byArray;
        Object[] params = objectArray;
        ReplicationSQL rep = new ReplicationSQL(1, tableName, sql, params);
        rep.setId(100L);
        System.out.println("create:" + (Object)((Object)rep));
        byte[] bin = rep.toBinary();
        MqPacket pk = MqNetUtil.convertMqPacket((byte[])bin);
        System.out.println("packet:" + pk);
    }
}

