/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.Serializable;
import org.maachang.util.OList;

public class ObjectList
implements OList,
Serializable {
    private static final long serialVersionUID = -4779348988405720333L;
    private Object[] array = null;
    private int startLength = 8;
    private int length = 8;
    private int nowLength = 0;

    public ObjectList() {
    }

    public ObjectList(int length) {
        this.length = this.startLength = length < 2 || length > Integer.MAX_VALUE ? 8 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.array = null;
        this.length = this.startLength;
        this.nowLength = 0;
    }

    public final void add(Object value) {
        Object[] info = null;
        Object[] tmp = null;
        info = this.array;
        int length = this.length;
        int nowSize = this.nowLength;
        if (info == null) {
            info = new Object[length];
            info[nowSize] = value;
            this.array = info;
        } else if (info.length <= nowSize) {
            tmp = info;
            info = new Object[length *= 2];
            System.arraycopy(tmp, 0, info, 0, nowSize);
            info[nowSize] = value;
            int i = 0;
            while (i < nowSize) {
                tmp[i] = null;
                ++i;
            }
            this.length = length;
            this.array = info;
        } else {
            info[nowSize] = value;
        }
        ++this.nowLength;
    }

    public final void set(int no, Object value) {
        int nowLen = this.nowLength;
        if (no < 0 || no >= nowLen) {
            return;
        }
        this.array[no] = value;
    }

    public final Object remove(int no) {
        Object[] info = null;
        Object[] tmp = null;
        Object ret = null;
        int nowSize = this.nowLength;
        int length = this.length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return null;
        }
        info = this.array;
        ret = info[no];
        info[no] = null;
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, 1, info, 0, nowSize - 1);
            info[nowSize - 1] = null;
        } else if (nowSize - no != 1) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = null;
        }
        if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
            int newLength = length / 2;
            tmp = new Object[newLength];
            System.arraycopy(info, 0, tmp, 0, newLength);
            int i = 0;
            while (i < nowSize) {
                info[i] = null;
                ++i;
            }
            info = null;
            info = tmp;
            this.length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.array = info;
        this.nowLength = nowSize;
        info = null;
        tmp = null;
        return ret;
    }

    public final Object get(int no) {
        if (no < 0 || no >= this.nowLength) {
            return null;
        }
        return this.array[no];
    }

    public final Object[] getObjects() {
        return this.array;
    }

    public final int size() {
        return this.nowLength;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[ ");
        int len = this.nowLength;
        int i = 0;
        while (i < len) {
            Object o;
            if (i != 0) {
                buf.append(", ");
            }
            if ((o = this.array[i]) == null) {
                buf.append("null@null");
            } else {
                buf.append(o).append("@").append(o.getClass().getName());
            }
            ++i;
        }
        return buf.append(" ]").toString();
    }
}

