/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflect {
    public static final Object newObject(String name) throws Exception {
        return Reflect.newObject(null, name);
    }

    public static final Object newObject(ClassLoader loader, String name) throws Exception {
        if (loader != null) {
            return Class.forName(name).newInstance();
        }
        return Class.forName(name, true, loader).newInstance();
    }

    public static final Object newObject(String name, Object ... params) throws Exception {
        return Reflect.newObject(name, null, params);
    }

    public static final Object newObject(String name, ClassLoader loader, Object ... params) throws Exception {
        if (params == null || params.length <= 0) {
            return Class.forName(name).newInstance();
        }
        int len = params.length;
        Class[] clss = new Class[len];
        int i = 0;
        while (i < len) {
            clss[i] = params[i].getClass();
            ++i;
        }
        Class<?> c = null;
        c = loader == null ? Class.forName(name) : Class.forName(name, true, loader);
        Constructor<?> cns = c.getConstructor(clss);
        return cns.newInstance(params);
    }

    public static final Object newObject(Class clzz) throws Exception {
        return clzz.newInstance();
    }

    public static final Object newObject(Class clzz, Object ... params) throws Exception {
        if (params == null || params.length <= 0) {
            return clzz.newInstance();
        }
        int len = params.length;
        Class[] clss = new Class[len];
        int i = 0;
        while (i < len) {
            clss[i] = params[i].getClass();
            ++i;
        }
        Constructor cns = clzz.getConstructor(clss);
        return cns.newInstance(params);
    }

    public static final Object executionMethod(String methodName, Object obj) throws Exception {
        if (methodName == null || (methodName = methodName.trim()).length() <= 0 || obj == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Method md = obj.getClass().getMethod(methodName, new Class[0]);
        return md.invoke(obj, new Object[0]);
    }

    public static final Object executionMethod(String methodName, Object obj, Object ... params) throws Exception {
        return Reflect.executionMethod(false, methodName, obj, params);
    }

    public static final Object executionMethod(boolean mode, String methodName, Object obj, Object ... params) throws Exception {
        if (methodName == null || (methodName = methodName.trim()).length() <= 0 || obj == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Class<?> cls = obj.getClass();
        if (params == null || params.length <= 0) {
            Method md = cls.getMethod(methodName, new Class[0]);
            return md.invoke(obj, new Object[0]);
        }
        Method target = Reflect.getSearchMethod(methodName, obj, params);
        if (target == null) {
            if (!mode) {
                StringBuilder buf = new StringBuilder();
                buf.append("\u6307\u5b9a\u30e1\u30bd\u30c3\u30c9 ").append(methodName).append("(");
                int len = params.length;
                int i = 0;
                while (i < len) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    if (params[i] == null) {
                        buf.append("null");
                    } else {
                        buf.append(params[i].getClass().getName());
                    }
                    ++i;
                }
                buf.append(") \u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                throw new NoSuchMethodException(buf.toString());
            }
            return null;
        }
        Method md = cls.getMethod(methodName, target.getParameterTypes());
        return md.invoke(obj, params);
    }

    public static final boolean isMethod(String methodName, Object obj) throws Exception {
        try {
            if (Reflect.getSearchMethod(methodName, obj, null) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final boolean isMethod(String methodName, Object obj, Object ... params) throws Exception {
        try {
            if (Reflect.getSearchMethod(methodName, obj, params) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static final ArrayList<String> getMethodNameByList(Object obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList<String> ret = new ArrayList<String>();
        Class<?> cls = obj.getClass();
        Method[] ms = cls.getMethods();
        if (ms != null && ms.length > 0) {
            int len = ms.length;
            int i = 0;
            while (i < len) {
                if (ms[i] != null) {
                    ret.add(ms[i].getName());
                }
                ++i;
            }
        }
        return ret;
    }

    public static final HashSet<String> getMethodNameByMap(Object obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        HashSet<String> ret = new HashSet<String>();
        Class<?> cls = obj.getClass();
        Method[] ms = cls.getMethods();
        if (ms != null && ms.length > 0) {
            int len = ms.length;
            int i = 0;
            while (i < len) {
                if (ms[i] != null) {
                    ret.add(ms[i].getName());
                }
                ++i;
            }
        }
        return ret;
    }

    public static final ArrayList<Method> getMethodObjectList(Object obj) throws Exception {
        if (obj == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList<Method> ret = new ArrayList<Method>();
        Class<?> cls = obj.getClass();
        Method[] ms = cls.getMethods();
        if (ms != null && ms.length > 0) {
            int len = ms.length;
            int i = 0;
            while (i < len) {
                if (ms[i] != null) {
                    ret.add(ms[i]);
                }
                ++i;
            }
        }
        return ret;
    }

    public static final boolean equalsClass(Class src, Class dest) {
        if (src == null || dest == null) {
            return false;
        }
        if (src.isPrimitive()) {
            if (dest.isPrimitive()) {
                return src == dest;
            }
            return src == Boolean.TYPE && dest == Boolean.class || src == Character.TYPE && dest == Boolean.class || src == Byte.TYPE && dest == Byte.class || src == Short.TYPE && dest == Short.class || src == Integer.TYPE && dest == Integer.class || src == Long.TYPE && dest == Long.class || src == Float.TYPE && dest == Float.class || src == Double.TYPE && dest == Double.class || src == Void.TYPE && dest == Void.class;
        }
        if (dest.isPrimitive()) {
            return dest == Boolean.TYPE && src == Boolean.class || dest == Character.TYPE && src == Boolean.class || dest == Byte.TYPE && src == Byte.class || dest == Short.TYPE && src == Short.class || dest == Integer.TYPE && src == Integer.class || dest == Long.TYPE && src == Long.class || dest == Float.TYPE && src == Float.class || dest == Double.TYPE && src == Double.class || dest == Void.TYPE && src == Void.class;
        }
        if (src.isInterface()) {
            if (dest.isInterface()) {
                return src.equals(dest);
            }
            HashSet<String> destSet = Reflect.getInterfaceAll(null, dest);
            return destSet.contains(src.getName());
        }
        if (dest.isInterface()) {
            HashSet<String> srcSet = Reflect.getInterfaceAll(null, src);
            return srcSet.contains(dest.getName());
        }
        HashSet<String> srcSet = Reflect.getClassAll(src);
        HashSet<String> destSet = Reflect.getClassAll(dest);
        if (srcSet.size() <= 0 && destSet.size() <= 0) {
            return false;
        }
        int len = srcSet.size();
        Object[] objs = srcSet.toArray();
        int i = 0;
        while (i < len) {
            if (destSet.contains((String)objs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final HashMap<String, Object> getter(Object object) throws Exception {
        if (object == null) {
            return new HashMap<String, Object>();
        }
        ArrayList<Method> mds = Reflect.getMethodObjectList(object);
        if (mds != null && mds.size() > 0) {
            HashMap<String, Object> ret = new HashMap<String, Object>();
            int len = mds.size();
            int i = 0;
            while (i < len) {
                Method md = mds.get(i);
                String name = md.getName();
                if ((md.getParameterTypes() == null || md.getParameterTypes().length <= 0) && (name.startsWith("get") || name.startsWith("is"))) {
                    String key = null;
                    key = name.startsWith("get") ? name.substring("get".length(), name.length()) : name.substring("is".length(), name.length());
                    key = String.valueOf(key.substring(0, 1).toLowerCase()) + key.substring(1, key.length());
                    Object val = Reflect.executionMethod(name, object);
                    ret.put(key, val);
                }
                ++i;
            }
            return ret;
        }
        return new HashMap<String, Object>();
    }

    public static final String toString(Object object) throws Exception {
        if (object == null) {
            return "";
        }
        HashMap<String, Object> map = Reflect.getter(object);
        int size = map.size();
        if (size > 0) {
            Object[] objs = map.keySet().toArray();
            StringBuilder buf = new StringBuilder(1024);
            int i = 0;
            while (i < size) {
                Object val = map.get((String)objs[i]);
                if (val == null) {
                    val = "";
                }
                buf.append(" ").append(objs[i]).append(":\"").append(val).append("\"");
                ++i;
            }
            return buf.toString();
        }
        return "";
    }

    private static final HashSet<String> getClassAll(Class cls) {
        if (cls == null) {
            return new HashSet<String>();
        }
        HashSet<String> ret = new HashSet<String>();
        Class tmp = cls;
        int i = 0;
        while (tmp != null && !Object.class.equals((Object)tmp)) {
            ret.add(tmp.getName());
            tmp = tmp.getSuperclass();
            ++i;
        }
        return ret;
    }

    private static final HashSet<String> getInterfaceAll(HashSet<String> out, Class cls) {
        if (cls == null) {
            if (out != null) {
                return out;
            }
            return new HashSet<String>();
        }
        HashSet<String> ret = out == null ? new HashSet<String>() : out;
        Class<?>[] ifc = cls.getInterfaces();
        int len = ifc.length;
        int i = 0;
        while (i < len) {
            ret.add(ifc[i].getName());
            ++i;
        }
        return ret;
    }

    private static final Method getSearchMethod(String methodName, Object object, Object[] args) throws Exception {
        if (methodName != null && object != null) {
            int argsLen = args == null ? 0 : args.length;
            Method[] list = object.getClass().getMethods();
            if (list != null && list.length > 0) {
                int len = list.length;
                int i = 0;
                while (i < len) {
                    if (methodName.equals(list[i].getName())) {
                        Class<?>[] params = list[i].getParameterTypes();
                        if (argsLen == 0 && (params == null || params.length == 0)) {
                            return list[i];
                        }
                        if (argsLen == params.length) {
                            boolean equalsFlag = true;
                            int lenJ = params.length;
                            int j = 0;
                            while (j < lenJ) {
                                if (args[j] != null && !Reflect.equalsClass(args[j].getClass(), params[j])) {
                                    equalsFlag = false;
                                    break;
                                }
                                ++j;
                            }
                            if (equalsFlag) {
                                return list[i];
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return null;
    }
}

