/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.maachang.util.Sequence;
import org.maachang.util.atomic.AtomicINT;

public class SequenceSync
extends Sequence {
    protected int maxId = 0;
    protected int startId = 0;
    protected final AtomicINT id = new AtomicINT(-1);

    public SequenceSync() {
        this.create();
    }

    public SequenceSync(int start, int max) {
        try {
            this.create(start, max);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create() {
        try {
            this.create(0, Integer.MAX_VALUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void create(int start, int max) throws Exception {
        if (start < 0 || max <= 1 || start >= max - 1 || max > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.maxId = max;
        this.startId = start;
        this.id.set(start);
    }

    public void clear() {
        this.id.set(this.startId);
    }

    public int getId() {
        int ret = this.id.inc();
        if (ret >= this.maxId) {
            this.id.set(this.startId);
            ret = this.startId;
        }
        return ret;
    }

    public int getStartId() {
        return this.startId;
    }

    public int getMaxID() {
        return this.maxId;
    }
}

