/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipList<E>
extends AbstractList<E>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8750206937467686912L;
    protected Entry<E> head;
    protected int size;
    private int randomSeed;

    public SkipList() {
        Random rand = new Random();
        this.randomSeed = rand.nextInt() | 0x100;
        this.buildHead();
    }

    private void buildHead() {
        this.head = new Entry();
        this.head.prev = this.head;
        this.head.next = this.head;
    }

    private int generateRandomLevel() {
        int x = this.randomSeed;
        x ^= x << 13;
        x ^= x >>> 17;
        x ^= x << 5;
        this.randomSeed = x;
        if ((x & 0x8001) != 0) {
            return 0;
        }
        int level = 0;
        while (((x >>>= 1) & 1) != 0) {
            ++level;
        }
        return level;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Entry<E> addBefore(E element, Entry<E> entry) {
        headLevel = this.head.level();
        level = Math.min(this.generateRandomLevel(), headLevel + 1);
        if (level > headLevel) {
            pts = new Pointer[level];
            i = 0;
            while (i < headLevel) {
                pts[i] = this.head.pts[i];
                ++i;
            }
            i = headLevel;
            while (i < level) {
                pts[i] = new Pointer<E>(this.head, this.head, 0);
                ++i;
            }
            this.head.pts = pts;
            headLevel = level;
        }
        prev = entry.prev;
        next /* !! */  = entry;
        e = new Entry<T>(level, prev, next /* !! */ , element);
        next /* !! */ .prev = e;
        prev.next = e;
        prevDistance = 1;
        nextDistance = 1;
        i = 0;
        ** GOTO lbl53
        {
            ++prevDistance;
            prev = prev.prev;
            do {
                if (prev.pts == null) continue block2;
                lv = prev.level();
                while (lv <= i) {
                    prevPt = prev.pts[lv - 1];
                    prevDistance += prevPt.prev.pts[lv - 1].distance;
                    prev = prevPt.prev;
                    lv = prev.pts.length;
                }
                while (next /* !! */ .pts == null) {
                    ++nextDistance;
                    next /* !! */  = next /* !! */ .next;
                }
                lv = next /* !! */ .level();
                while (lv <= i) {
                    nextPt = next /* !! */ .pts[lv - 1];
                    nextDistance += nextPt.distance;
                    next /* !! */  = nextPt.next;
                    lv = next /* !! */ .pts.length;
                }
                e.pts[i] = new Pointer<T>(prev, next /* !! */ , nextDistance);
                prev.pts[i].next = e;
                prev.pts[i].distance = prevDistance;
                next /* !! */ .pts[i].prev = e;
                ++i;
lbl53:
                // 2 sources

            } while (i < level);
        }
        i = level;
        ** GOTO lbl64
        {
            prev = prev.prev;
            do {
                if (prev.pts == null) continue block7;
                while (prev.pts.length <= i) {
                    prev = prev.pts[prev.pts.length - 1].prev;
                }
                ++prev.pts[i].distance;
                ++i;
lbl64:
                // 2 sources

            } while (i < headLevel);
        }
        ++this.size;
        return e;
    }

    protected Entry<E> getEntry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("size: " + this.size + ", index: " + index);
        }
        Entry<Object> e = this.head;
        int level = e.level();
        int curIndex = -1;
        while (curIndex != index) {
            if (level == 0) {
                e = e.next;
                ++curIndex;
                continue;
            }
            Pointer p = e.pts[level - 1];
            int n = curIndex + p.distance;
            if (n <= index) {
                e = p.next;
                curIndex = n;
                continue;
            }
            --level;
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    protected void removeEntry(Entry<E> entry) {
        prev = entry.prev;
        prev.next = next = entry.next;
        next.prev = prev;
        level = entry.level();
        if (level > 0) {
            i = 0;
            while (i < level) {
                p = entry.pts[i];
                prev = p.prev;
                next = p.next;
                prev.pts[i].next = next;
                next.pts[i].prev = prev;
                prev.pts[i].distance += p.distance - 1;
                ++i;
            }
            prev = entry.pts[level - 1].prev;
        }
        headLevel = this.head.level();
        i = level;
        ** GOTO lbl28
        {
            prev = prev.prev;
            do {
                if (prev.pts == null) continue block1;
                while (i >= prev.pts.length) {
                    prev = prev.pts[prev.pts.length - 1].prev;
                }
                --prev.pts[i].distance;
                ++i;
lbl28:
                // 2 sources

            } while (i < headLevel);
        }
        --this.size;
    }

    protected int getIndex(Entry<E> entry) {
        Entry<Object> e = entry;
        int distance = 0;
        while (e != this.head) {
            if (e.pts == null) {
                ++distance;
                e = e.next;
                continue;
            }
            Pointer p = e.pts[e.pts.length - 1];
            distance += p.distance;
            e = p.next;
        }
        return this.size - distance;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.buildHead();
        this.size = 0;
    }

    @Override
    public boolean add(E element) {
        this.addBefore(element, this.head);
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.addBefore(element, this.head);
        } else {
            Entry<E> entry = this.getEntry(index);
            this.addBefore(element, entry);
        }
    }

    @Override
    public E remove(int index) {
        Entry<E> entry = this.getEntry(index);
        this.removeEntry(entry);
        return (E)entry.value;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    @Override
    public E get(int index) {
        return (E)this.getEntry((int)index).value;
    }

    @Override
    public E set(int index, E value) {
        Entry<E> entry = this.getEntry(index);
        Object oldValue = entry.value;
        entry.value = value;
        return (E)oldValue;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int indexOf(Object o) {
        block4: {
            index = 0;
            e = this.head.next;
            if (o != null) ** GOTO lbl15
            while (e != this.head) {
                if (e.value == null) {
                    return index;
                }
                e = e.next;
                ++index;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (e.value.equals(o)) {
                    return index;
                }
                e = e.next;
                ++index;
lbl15:
                // 2 sources

                ** while (e != this.head)
            }
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int lastIndexOf(Object o) {
        block4: {
            index = this.size - 1;
            e = this.head.prev;
            if (o != null) ** GOTO lbl15
            while (e != this.head) {
                if (e.value == null) {
                    return index;
                }
                e = e.prev;
                --index;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                if (e.value.equals(o)) {
                    return index;
                }
                e = e.prev;
                --index;
lbl15:
                // 2 sources

                ** while (e != this.head)
            }
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new EntryIterator(this.head);
    }

    public Iterator<E> backwardIterator() {
        return new BackwardEntryIterator(this.head);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Pointer<T>
    implements Serializable {
        private static final long serialVersionUID = -5260753036548236032L;
        public Entry<T> prev;
        public Entry<T> next;
        public int distance;

        public Pointer(Entry<T> prev, Entry<T> next, int distance) {
            this.prev = prev;
            this.next = next;
            this.distance = distance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<T>
    implements Serializable {
        private static final long serialVersionUID = 6623755413831454813L;
        public Pointer<T>[] pts;
        public Entry<T> prev;
        public Entry<T> next;
        public T value;

        public Entry() {
        }

        public Entry(int level, Entry<T> prev, Entry<T> next, T value) {
            if (level > 0) {
                this.pts = new Pointer[level];
            }
            this.prev = prev;
            this.next = next;
            this.value = value;
        }

        public int level() {
            return this.pts != null ? this.pts.length : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntryIterator
    implements Iterator<E> {
        private Entry<E> current;
        private int expectedSize;

        public EntryIterator(Entry<E> current) {
            this.current = current;
            this.expectedSize = SkipList.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != SkipList.this.head;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.current.next;
            return this.current.value;
        }

        @Override
        public void remove() {
            if (this.expectedSize != SkipList.this.size) {
                throw new ConcurrentModificationException();
            }
            SkipList.this.removeEntry(this.current);
            this.expectedSize = SkipList.this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class BackwardEntryIterator
    implements Iterator<E> {
        private Entry<E> current;
        private int expectedSize;

        public BackwardEntryIterator(Entry<E> current) {
            this.current = current;
            this.expectedSize = SkipList.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.current.prev != SkipList.this.head;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.current = this.current.prev;
            return this.current.value;
        }

        @Override
        public void remove() {
            if (this.expectedSize != SkipList.this.size) {
                throw new ConcurrentModificationException();
            }
            SkipList.this.removeEntry(this.current);
            this.expectedSize = SkipList.this.size;
        }
    }
}

