/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.maachang.util.SkipList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipListSet<E>
extends SkipList<E>
implements Set<E> {
    private static final long serialVersionUID = 3736529741483124077L;
    private Map<E, SkipList.Entry<E>> map = new HashMap<E, SkipList.Entry<E>>();

    @Override
    public boolean add(E element) {
        if (this.map.containsKey(element)) {
            return false;
        }
        SkipList.Entry<E> entry = this.addBefore(element, this.head);
        this.map.put(element, entry);
        return true;
    }

    @Override
    public void add(int index, E element) {
        SkipList.Entry<E> entry;
        if (this.map.containsKey(element)) {
            return;
        }
        if (index == this.size) {
            entry = this.addBefore(element, this.head);
        } else {
            SkipList.Entry next = this.getEntry(index);
            entry = this.addBefore(element, next);
        }
        this.map.put(element, entry);
    }

    @Override
    public E set(int index, E value) {
        SkipList.Entry entry = this.getEntry(index);
        Object oldValue = entry.value;
        entry.value = value;
        this.map.remove(oldValue);
        this.map.put(value, entry);
        return (E)oldValue;
    }

    @Override
    public void clear() {
        super.clear();
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public int indexOf(Object o) {
        SkipList.Entry<E> entry = this.map.get(o);
        if (entry == null) {
            return -1;
        }
        return this.getIndex(entry);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public boolean remove(Object o) {
        SkipList.Entry<E> entry = this.map.get(o);
        if (entry == null) {
            return false;
        }
        this.removeEntry(entry);
        this.map.remove(o);
        return true;
    }

    @Override
    public E remove(int index) {
        Object item = this.get(index);
        this.remove(item);
        return item;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = super.removeAll(c);
        for (Object e : c) {
            this.map.remove(e);
        }
        return result;
    }
}

