/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicARRAY<T>
implements Serializable {
    private static final long serialVersionUID = -70907164927496290L;
    private AtomicReferenceArray<T> ato = null;
    private int size = -1;

    private AtomicARRAY() {
    }

    public AtomicARRAY(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("\u914d\u5217\u6570\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.ato = new AtomicReferenceArray(size);
        this.size = size;
    }

    public T get(int no) {
        if (no < 0 || no >= this.size) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7bc4\u56f2\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return this.ato.get(no);
    }

    public void set(T t, int no) {
        if (no < 0 || no >= this.size) {
            throw new IllegalArgumentException("\u6307\u5b9a\u7bc4\u56f2\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.setting(t, no);
    }

    public int size() {
        return this.ato.length();
    }

    private void setting(T t, int no) {
        while (!this.ato.compareAndSet(no, this.ato.get(no), t)) {
        }
    }
}

