/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import org.maachang.util.atomic.AtomicPrimitive;

public class AtomicFLOAT
implements Serializable,
AtomicPrimitive {
    private static final long serialVersionUID = -5471996857123960748L;
    private final AtomicInteger ato = new AtomicInteger(0);

    public AtomicFLOAT() {
    }

    public AtomicFLOAT(float n) {
        this.setting(Float.floatToIntBits(n));
    }

    public AtomicFLOAT(Float n) {
        if (n != null) {
            this.setting(Float.floatToIntBits(n.floatValue()));
        }
    }

    public float get() {
        return Float.intBitsToFloat(this.ato.get());
    }

    public Float getObject() {
        return new Float(this.get());
    }

    public void set(float n) {
        this.setting(Float.floatToIntBits(n));
    }

    public void set(Float n) {
        if (n != null) {
            this.setting(Float.floatToIntBits(n.floatValue()));
        }
    }

    public float add(float no) {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) + no))) {
        }
        return Float.intBitsToFloat(r);
    }

    public float add(Float no) {
        int r;
        int n;
        if (no == null) {
            return -1.0f;
        }
        float x = no.floatValue();
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) + x))) {
        }
        return Float.intBitsToFloat(r);
    }

    public float remove(float no) {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) - no))) {
        }
        return Float.intBitsToFloat(r);
    }

    public float remove(Float no) {
        int r;
        int n;
        if (no == null) {
            return -1.0f;
        }
        float x = no.floatValue();
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) - x))) {
        }
        return Float.intBitsToFloat(r);
    }

    public float inc() {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) + 1.0f))) {
        }
        return Float.intBitsToFloat(r);
    }

    public float dec() {
        int r;
        int n;
        while (!this.ato.compareAndSet(n = this.ato.get(), r = Float.floatToIntBits(Float.intBitsToFloat(n) - 1.0f))) {
        }
        return Float.intBitsToFloat(r);
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public Object base() {
        return this.ato;
    }

    public int getType() {
        return 6;
    }

    private void setting(int no) {
        while (!this.ato.compareAndSet(this.ato.get(), no)) {
        }
    }
}

