/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.util.concurrent.atomic.AtomicInteger;
import org.maachang.util.AbstractBaseRandom;
import org.maachang.util.BaseRandom;
import org.maachang.util.atomic.AtomicLONG;

public class AtomicXor128Random
extends AbstractBaseRandom
implements BaseRandom {
    private static final long serialVersionUID = 4646272181287409322L;
    private static final AtomicLONG seedUniquifier = new AtomicLONG(8682522807148012L);
    private final AtomicInteger ax = new AtomicInteger(123456789);
    private final AtomicInteger ay = new AtomicInteger(362436069);
    private final AtomicInteger az = new AtomicInteger(521288629);
    private final AtomicInteger aw = new AtomicInteger(88675123);

    private long nano8bit() {
        return System.nanoTime() & 0xFFL;
    }

    public AtomicXor128Random() {
        this(seedUniquifier.inc());
    }

    public AtomicXor128Random(long seed) {
        this.setSeed(seed);
    }

    public final void setSeed(long seed) {
        seed = seed * this.nano8bit() & 0xFFFFFFFFFFFFFFL;
        this.aw.set((int)(seed & 0xFFFFFFFFL));
        this.nextInt();
        this.aw.set(this.aw.get() ^ (int)((seed & 0xFFFFFFFF00000000L) >> 32));
        this.nextInt();
    }

    public final int nextInt() {
        int t;
        int x = this.ax.get();
        int y = this.ay.get();
        int z = this.az.get();
        int w = this.aw.get();
        int r = t = x;
        t <<= 11;
        t ^= r;
        r = t;
        t ^= (r >>= 8);
        x = r = y;
        y = r = z;
        z = r = w;
        t ^= r;
        r >>= 19;
        w = r ^= t;
        this.ax.compareAndSet(this.ax.get(), x);
        this.ay.compareAndSet(this.ay.get(), y);
        this.az.compareAndSet(this.az.get(), z);
        this.aw.compareAndSet(this.aw.get(), w);
        return w;
    }
}

