/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.atomic;

import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.maachang.util.OList;

public class RWLockList
implements OList,
Serializable {
    private static final long serialVersionUID = 6773785245454013996L;
    private Object[] array = null;
    private int startLength = 8;
    private int length = 8;
    private int nowLength = 0;
    private final ReentrantReadWriteLock sync = new ReentrantReadWriteLock();
    private final Lock rsync = this.sync.readLock();
    private final Lock wsync = this.sync.writeLock();

    public RWLockList() {
    }

    public RWLockList(int length) {
        this.length = this.startLength = length < 2 || length > Integer.MAX_VALUE ? 8 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.wsync.lock();
        try {
            this.array = null;
            this.length = this.startLength;
            this.nowLength = 0;
        }
        finally {
            this.wsync.unlock();
        }
    }

    public final void add(Object value) {
        this.wsync.lock();
        try {
            Object[] info = null;
            Object[] tmp = null;
            info = this.array;
            int length = this.length;
            int nowSize = this.nowLength;
            if (info == null) {
                info = new Object[length];
                info[nowSize] = value;
                this.array = info;
            } else if (info.length <= nowSize) {
                tmp = info;
                info = new Object[length *= 2];
                System.arraycopy(tmp, 0, info, 0, nowSize);
                info[nowSize] = value;
                int i = 0;
                while (i < nowSize) {
                    tmp[i] = null;
                    ++i;
                }
                this.length = length;
                this.array = info;
            } else {
                info[nowSize] = value;
            }
            ++this.nowLength;
        }
        finally {
            this.wsync.unlock();
        }
    }

    public final void set(int no, Object value) {
        this.wsync.lock();
        try {
            int nowLen = this.nowLength;
            if (no < 0 || no >= nowLen) {
                return;
            }
            this.array[no] = value;
        }
        finally {
            this.wsync.unlock();
        }
    }

    public final Object remove(int no) {
        this.wsync.lock();
        try {
            Object[] info = null;
            Object[] tmp = null;
            Object ret = null;
            int nowSize = this.nowLength;
            int length = this.length;
            if (no < 0 || no >= nowSize || nowSize == 0) {
                Object var10_7 = null;
                return var10_7;
            }
            info = this.array;
            ret = info[no];
            info[no] = null;
            if (no == 0) {
                tmp = info;
                System.arraycopy(tmp, 1, info, 0, nowSize - 1);
                info[nowSize - 1] = null;
            } else if (nowSize - no != 1) {
                tmp = info;
                System.arraycopy(tmp, 0, info, 0, no);
                System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
                info[nowSize - 1] = null;
            }
            if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
                int newLength = length / 2;
                tmp = new Object[newLength];
                System.arraycopy(info, 0, tmp, 0, newLength);
                int i = 0;
                while (i < nowSize) {
                    info[i] = null;
                    ++i;
                }
                info = null;
                info = tmp;
                this.length = newLength;
            } else if (nowSize == 0) {
                info = null;
            }
            this.array = info;
            this.nowLength = nowSize;
            info = null;
            tmp = null;
            Object object = ret;
            return object;
        }
        finally {
            this.wsync.unlock();
        }
    }

    public final Object get(int no) {
        this.rsync.lock();
        try {
            if (no < 0 || no >= this.nowLength) {
                Object var3_2 = null;
                return var3_2;
            }
            Object object = this.array[no];
            return object;
        }
        finally {
            this.rsync.unlock();
        }
    }

    public final Object[] getObjects() {
        this.rsync.lock();
        Object[] ret = this.array;
        this.rsync.unlock();
        return ret;
    }

    public final int size() {
        this.rsync.lock();
        int ret = this.nowLength;
        this.rsync.unlock();
        return ret;
    }

    public final String toString() {
        this.rsync.lock();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("[ ");
            int len = this.nowLength;
            int i = 0;
            while (i < len) {
                Object o;
                if (i != 0) {
                    buf.append(", ");
                }
                if ((o = this.array[i]) == null) {
                    buf.append("null@null");
                } else {
                    buf.append(o).append("@").append(o.getClass().getName());
                }
                ++i;
            }
            String string = buf.append(" ]").toString();
            return string;
        }
        finally {
            this.rsync.unlock();
        }
    }
}

