/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.maachang.util.nativeio.NativeIODefine;
import org.maachang.util.nativeio.RandomIO;

class JavaRandomIO
implements RandomIO {
    private RandomAccessFile fp = null;
    private String name = null;

    private JavaRandomIO() {
    }

    public JavaRandomIO(String name) throws Exception {
        RandomAccessFile fp;
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = NativeIODefine.fullPath(name);
        this.fp = fp = new RandomAccessFile(name, "rwd");
        this.name = name;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (this.isOpen()) {
            try {
                this.fp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fp = null;
        this.name = null;
    }

    public int read(byte[] binary, long seek, int offset, int length) throws Exception {
        if (binary == null || binary.length <= 0 || seek <= -1L && offset <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? binary.length - offset : length;
        if (length <= 0 || length > binary.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.fp.seek(seek);
        return this.fp.read(binary, offset, length);
    }

    public void write(byte[] binary, long seek, int offset, int length) throws Exception {
        if (binary == null || binary.length <= 0 || seek <= -1L && offset <= -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        int n = length = length <= 0 ? binary.length - offset : length;
        if (length <= 0 || length > binary.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.fp.seek(seek);
        this.fp.write(binary, offset, length);
    }

    public long length() throws Exception {
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.fp.length();
    }

    public void length(long length) throws Exception {
        if (length <= -1L) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!this.isOpen()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        this.fp.setLength(length);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return 1;
    }

    public boolean isOpen() {
        return this.name != null;
    }
}

