/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.util.nativeio.JavaRandomIO;
import org.maachang.util.nativeio.NativeIO;
import org.maachang.util.nativeio.NativeInputStream;
import org.maachang.util.nativeio.NativeOutputStream;
import org.maachang.util.nativeio.NativeRandomIO;
import org.maachang.util.nativeio.RandomIO;

public abstract class NativeIOInstance {
    private NativeIOInstance() {
    }

    public static final RandomIO randomIO(String name) throws Exception {
        if (NativeIO.useInit()) {
            return new NativeRandomIO(name);
        }
        return new JavaRandomIO(name);
    }

    public static final InputStream inputStream(String name) throws Exception {
        if (NativeIO.useInit()) {
            return new NativeInputStream(name);
        }
        return new BufferedInputStream(new FileInputStream(name));
    }

    public static final OutputStream outputStream(String name) throws Exception {
        return NativeIOInstance.outputStream(true, name);
    }

    public static final OutputStream outputStream(boolean mode, String name) throws Exception {
        if (NativeIO.useInit()) {
            return new NativeOutputStream(mode, name);
        }
        if (!mode) {
            return new BufferedOutputStream(new FileOutputStream(name, true));
        }
        return new BufferedOutputStream(new FileOutputStream(name));
    }
}

