/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.nativeio;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.util.nativeio.NativeIO;
import org.maachang.util.nativeio.NativeIODefine;

class NativeOutputStream
extends OutputStream {
    private static final int TEMP_LEN = 4096;
    private final byte[] temp = new byte[4096];
    private int position = 0;
    private long handle = -1L;

    private NativeOutputStream() {
    }

    public NativeOutputStream(boolean mode, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = NativeIODefine.fullPath(name);
        boolean useFileFlag = NativeIODefine.useFile(name);
        this.handle = NativeIO.open(1, 1, NativeIODefine.nativeString(name));
        if (this.handle == -1L) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        if (useFileFlag && mode) {
            NativeIO.setLength(this.handle, 0L);
        }
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() throws IOException {
        if (this.handle > -1L) {
            this.flush();
            NativeIO.close(this.handle);
            this.handle = -1L;
            this.position = 0;
        }
    }

    public void flush() throws IOException {
        if (this.handle <= -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.position > 0) {
            NativeIO.write(this.handle, -1L, this.temp, 0, this.position);
            this.position = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.position >= 4096) {
            this.flush();
        }
        this.temp[this.position] = (byte)b;
        ++this.position;
    }
}

