/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.util.List;
import org.maachang.util.StringUtil;
import org.maachang.util.net.AbstractNetAdapter;

class NetAdapterByBsd
extends AbstractNetAdapter {
    private static final String IPCONFIG_COMMAND = "ifconfig -a";
    private static final String ADAPTER_NAME_1 = "flags";
    private static final String ADAPTER_NAME_2 = "=";
    private static final char DIV_IP_CODE = '.';
    private static final char DIV_MAC_CODE = ':';
    private static final String IP_ADDR = "inet";
    private static final String SUB_NET = "netmask";
    private static final String MAC_ADDR = "ether";
    private static final String SUB_NET_HEADER = "0x";

    public NetAdapterByBsd() {
        this.init();
    }

    public void load() throws Exception {
        List<String> cmdOut = null;
        String name = null;
        String value = null;
        try {
            try {
                this.clear();
                cmdOut = AbstractNetAdapter.runExec(IPCONFIG_COMMAND);
                int len = cmdOut.size();
                int i = 0;
                int localCheck = 0;
                while (i < len) {
                    char code;
                    int et;
                    int st;
                    int j;
                    int lenJ;
                    int pnt;
                    String bcmd = cmdOut.get(i);
                    String cmd = bcmd.toLowerCase();
                    int off = cmd.indexOf(ADAPTER_NAME_1);
                    if (off != -1 && cmd.indexOf(ADAPTER_NAME_2, off) != -1) {
                        pnt = off;
                        name = StringUtil.trim(bcmd.substring(0, cmd.indexOf(58)));
                    }
                    if ((pnt = cmd.indexOf(IP_ADDR)) != -1) {
                        lenJ = cmd.length();
                        j = pnt += IP_ADDR.length();
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9') {
                                    st = j;
                                }
                            } else {
                                if (code != '.' && (code < '0' || code > '9')) break;
                                et = j;
                            }
                            ++j;
                        }
                        if ((value = StringUtil.trim(bcmd.substring(st, et + 1))).equals("127.0.0.1")) {
                            ++localCheck;
                        }
                        super.setIpAddress(name, value);
                    }
                    if ((off = cmd.indexOf(SUB_NET)) != -1) {
                        pnt = cmd.indexOf(SUB_NET_HEADER, off);
                        pnt = pnt != -1 ? (pnt += SUB_NET_HEADER.length()) : off + SUB_NET.length();
                        lenJ = cmd.length();
                        j = pnt;
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                                    st = j;
                                }
                            } else {
                                if ((code < '0' || code > '9') && (code < 'a' || code > 'f')) break;
                                et = j;
                            }
                            ++j;
                        }
                        value = StringUtil.trim(StringUtil.changeString(bcmd.substring(st, et + 1), SUB_NET, " "));
                        super.setSubnetMask(name, NetAdapterByBsd.convertStringByIpAddress(value));
                    }
                    if ((pnt = cmd.indexOf(MAC_ADDR)) != -1) {
                        lenJ = cmd.length();
                        j = pnt += MAC_ADDR.length();
                        st = -1;
                        et = -1;
                        while (j < lenJ) {
                            code = cmd.charAt(j);
                            if (st == -1) {
                                if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f') {
                                    st = j;
                                }
                            } else {
                                if (code != ':' && (code < '0' || code > '9') && (code < 'a' || code > 'f')) break;
                                et = j;
                            }
                            ++j;
                        }
                        value = StringUtil.trim(bcmd.substring(st, et + 1)).toUpperCase();
                        super.setMacAddress(name, value);
                    }
                    ++i;
                }
                if (localCheck == 0) {
                    super.setIpAddress("lo", "127.0.0.1");
                    super.setSubnetMask("lo", "255.0.0.0");
                }
            }
            catch (Exception e) {
                this.clear();
                throw e;
            }
        }
        finally {
            cmdOut = null;
            name = null;
            value = null;
        }
    }

    private static final String convertStringByIpAddress(String code) {
        byte[] bin = null;
        StringBuilder buf = null;
        String ret = null;
        buf = new StringBuilder();
        try {
            try {
                bin = NetAdapterByBsd.convertString16ToBinary(code.toUpperCase());
                int len = bin.length;
                int i = 0;
                while (i < len) {
                    if (i != 0) {
                        buf.append('.');
                    }
                    buf.append(bin[i] & 0xFF);
                    ++i;
                }
                ret = buf.toString();
            }
            catch (Exception t) {
                ret = "0.0.0.0";
            }
        }
        finally {
            bin = null;
            buf = null;
        }
        return ret;
    }
}

