/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.thread;

import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicINT;

public abstract class LoopThread
extends Thread {
    private final AtomicBOOL stopFlag = new AtomicBOOL(true);
    protected final AtomicINT threadId = new AtomicINT(-1);

    protected abstract void clear();

    protected abstract boolean execution() throws Exception;

    protected void toException(Throwable e) {
    }

    public void startThread() throws Exception {
        this.stopFlag.set(false);
        this.setDaemon(true);
        this.start();
    }

    public int getThreadId() {
        return this.threadId.get();
    }

    public void stopThread() {
        this.stopFlag.set(true);
    }

    public boolean isStop() {
        return this.stopFlag.get();
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.stopFlag.get()) {
            try {
                if (this.execution()) continue;
                Thread.sleep(30L);
            }
            catch (InterruptedException ite) {
                this.toException(ite);
                endFlag = true;
            }
            catch (NullPointerException ne) {
                this.toException(ne);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (OutOfMemoryError mem) {
                this.toException(mem);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (Exception e) {
                this.toException(e);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (ThreadDeath td) {
                this.toException(td);
                endFlag = true;
                threadDeach = td;
            }
        }
        this.clear();
        this.stopFlag.set(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

