/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.report;

import java.io.IOException;
import java.util.Iterator;
import org.maachang.report.CellPosition;
import org.maachang.report.CellPositionList;
import org.maachang.report.CellStyle;
import org.maachang.report.CellStyleList;
import org.maachang.report.ExcelSheet;

class ReportCore {
    private ExcelSheet element = null;
    private CellStyleList csList = null;
    private CellPositionList cpList = null;
    private volatile boolean fixFlag = false;

    private ReportCore() {
    }

    public ReportCore(String name, String sheetName) throws Exception {
        this.element = new ExcelSheet(name, sheetName);
        this.csList = new CellStyleList();
        this.cpList = null;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.element != null) {
            this.element.destroy();
        }
        this.element = null;
        this.csList = null;
        this.cpList = null;
        this.fixFlag = true;
    }

    public boolean isUse() {
        return this.element != null && this.element.isUse();
    }

    public boolean isFix() {
        return this.fixFlag;
    }

    public ExcelSheet getExcelSheet() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.element;
    }

    public CellStyleList getCellStyleList() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.csList;
    }

    public CellPositionList getCellPositionList() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.cpList;
    }

    public void fix() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.fixFlag) {
            return;
        }
        this.cpList = this.element.getCellPositionList(this.csList);
        if (this.cpList.size() <= 0) {
            throw new IOException("\u30c7\u30fc\u30bf\u8a2d\u5b9a\u5bfe\u8c61\u306e\u5909\u6570\u60c5\u5831\u304c\u5b58\u5728\u3057\u306a\u3044\u306e\u3067\u3001\u51e6\u7406\u3092\u4e2d\u65ad\u3057\u307e\u3059");
        }
        this.fixFlag = true;
    }

    public void addCellStyle(String name, int startXPos, int startYPos, int width, int height) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.fixFlag) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u3066\u3044\u307e\u3059");
        }
        CellStyle cs = new CellStyle(name, this.element.getSheet(), startXPos, startYPos, width, height);
        this.csList.put(cs);
    }

    public void addCellStyle(CellStyle cs) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (this.fixFlag) {
            throw new IOException("\u65e2\u306b\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u3066\u3044\u307e\u3059");
        }
        if (cs == null || !cs.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.csList.put(cs);
    }

    private void moveUnderCellStyle(CellStyle cs) {
        int addHeight = cs.getHeight();
        Iterator it = this.cpList.iterator();
        while (it.hasNext()) {
            CellPosition[] pos = this.cpList.get((String)it.next());
            int len = pos.length;
            int i = 0;
            while (i < len) {
                if (cs.isUnderRow(pos[i].getY())) {
                    pos[i].setY(pos[i].getY() + addHeight);
                }
                ++i;
            }
        }
        it = this.csList.iterator();
        while (it.hasNext()) {
            CellStyle target = this.csList.get((String)it.next());
            if (target == cs || !cs.isUnderRow(target.getStartY())) continue;
            target.addStartY(addHeight);
        }
    }

    private void moveThisCellStyle(CellStyle cs) {
        int addHeight = cs.getHeight();
        String csName = cs.getName();
        Iterator it = this.cpList.iterator();
        while (it.hasNext()) {
            CellPosition[] pos = this.cpList.get((String)it.next());
            int len = pos.length;
            int i = 0;
            while (i < len) {
                if (csName.equals(pos[i].getCellStyleName())) {
                    pos[i].setY(pos[i].getY() + addHeight);
                }
                ++i;
            }
        }
    }

    public void insertCellStyle(String name) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (!this.fixFlag) {
            throw new IOException("\u3053\u306e\u51e6\u7406\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u306a\u3044\u3068\u3001\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        CellStyle cs = this.csList.get(name);
        if (cs == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d[" + name + "]\u306e\u30bb\u30eb\u30b9\u30bf\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.moveUnderCellStyle(cs);
        this.element.pushRow(cs.getNowRow(), cs.getHeight());
        cs.copy(this.element.getSheet(), cs.getStartX(), cs.getNowRow());
        this.moveThisCellStyle(cs);
        cs.addNowRow();
    }

    public void pushSequence(String name) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (!this.fixFlag) {
            throw new IOException("\u3053\u306e\u51e6\u7406\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u306a\u3044\u3068\u3001\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        CellStyle cs = this.csList.get(name);
        if (cs == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d[" + name + "]\u306e\u30bb\u30eb\u30b9\u30bf\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        CellPosition p = this.cpList.getSequence(name);
        if (p != null) {
            this.element.setCell(p.getX(), p.getY(), (Object)new Integer(cs.getNowPos() + 1));
        }
    }
}

