/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;
import org.maachang.report.CellPosition;
import org.maachang.report.CellPositionList;
import org.maachang.report.CellStyle;
import org.maachang.report.CellStyleBean;
import org.maachang.report.ExcelSheet;
import org.maachang.report.ReportCore;
import org.maachang.report.ReportElement;
import org.maachang.util.StringUtil;

public class ReportEngine {
    private ReportCore core = null;
    private Set<String> csMan = null;
    private String outName = null;

    private ReportEngine() {
    }

    public ReportEngine(String name) throws Exception {
        this(name, Config.read((String)name));
    }

    public ReportEngine(String name, Config conf) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0 || conf == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        String excelFile = conf.get("excel", "name", 0);
        String sheetName = conf.get("excel", "sheet", 0);
        String outName = conf.get("excel", "outName", 0);
        if (excelFile == null || (excelFile = excelFile.trim()).length() <= 0) {
            excelFile = name.endsWith(".conf") ? String.valueOf(name.substring(0, name.length() - ".conf".length())) + ".xls" : null;
        }
        CellStyleBean[] cbList = null;
        String[] keys = conf.getKeys("cellStyle");
        if (keys != null && keys.length > 0) {
            ArrayList<CellStyleBean> lst = new ArrayList<CellStyleBean>();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                ArrayList csv;
                String v = conf.get("cellStyle", keys[i], 0);
                if (v != null && v.length() > 0 && (csv = StringUtil.cutString((String)v, (String)",")).size() == 4 && StringUtil.checkType((int)1, (String)((String)csv.get(1))) && StringUtil.checkType((int)1, (String)((String)csv.get(2))) && StringUtil.checkType((int)1, (String)((String)csv.get(3)))) {
                    CellStyleBean bean;
                    if (StringUtil.checkType((int)2, (String)((String)csv.get(0)))) {
                        bean = new CellStyleBean(keys[i], (String)csv.get(0), ConvIniParam.getInt((String)((String)csv.get(1))), ConvIniParam.getInt((String)((String)csv.get(2))), ConvIniParam.getInt((String)((String)csv.get(3))));
                        lst.add(bean);
                    } else if (StringUtil.checkType((int)1, (String)((String)csv.get(0)))) {
                        bean = new CellStyleBean(keys[i], ConvIniParam.getInt((String)((String)csv.get(0))), ConvIniParam.getInt((String)((String)csv.get(1))), ConvIniParam.getInt((String)((String)csv.get(2))), ConvIniParam.getInt((String)((String)csv.get(3))));
                        lst.add(bean);
                    }
                }
                ++i;
            }
            if (lst.size() != 0) {
                len = lst.size();
                cbList = new CellStyleBean[len];
                i = 0;
                while (i < len) {
                    cbList[i] = (CellStyleBean)lst.get(i);
                    ++i;
                }
                lst.clear();
            }
            lst = null;
        }
        this.createEngine(excelFile, sheetName, outName, cbList);
    }

    public ReportEngine(String excelFile, String sheetName, String outName, CellStyleBean[] cbList) throws Exception {
        this.createEngine(excelFile, sheetName, outName, cbList);
    }

    private void createEngine(String excelFile, String sheetName, String outName, CellStyleBean[] cbList) throws Exception {
        if (excelFile == null || (excelFile = excelFile.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u5bfe\u8c61\u306eExcel\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (sheetName == null || (sheetName = sheetName.trim()).length() <= 0) {
            sheetName = "Sheet1";
        }
        if (outName == null || (outName = outName.trim()).length() <= 0) {
            outName = "report.xls";
        }
        ReportCore pc = new ReportCore(excelFile, sheetName);
        HSSFSheet hs = pc.getExcelSheet().getSheet();
        int len = 0;
        if (cbList != null) {
            len = cbList.length;
        }
        int i = 0;
        while (i < len) {
            pc.addCellStyle(new CellStyle(cbList[i], hs));
            ++i;
        }
        pc.fix();
        this.core = pc;
        this.csMan = new HashSet<String>();
        this.outName = outName;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.core != null) {
            this.core.destroy();
        }
        this.core = null;
        this.csMan = null;
    }

    public void nextList() throws Exception {
        for (String name : this.csMan) {
            CellStyle cs = this.core.getCellStyleList().get(name);
            if (cs == null) continue;
            cs.insert();
        }
        this.csMan.clear();
    }

    public void putValue(String name, Object value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (!this.core.isFix()) {
            throw new IOException("\u3053\u306e\u51e6\u7406\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u306a\u3044\u3068\u3001\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name.startsWith("seq:")) {
            return;
        }
        if (value == null) {
            value = "";
        }
        CellPositionList cpList = this.core.getCellPositionList();
        ExcelSheet element = this.core.getExcelSheet();
        CellPosition[] cp = cpList.get(name);
        if (cp == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d[" + name + "]\u306e\u8981\u7d20\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int len = cp.length;
        int i = 0;
        while (i < len) {
            String csName;
            if (cp[i].getCellStyleName() != null && (csName = cp[i].getCellStyleName()) != null && !this.csMan.contains(csName)) {
                CellStyle cs = this.core.getCellStyleList().get(csName);
                if (cs != null && cs.isInsert()) {
                    this.core.insertCellStyle(csName);
                }
                this.core.pushSequence(csName);
                this.csMan.add(csName);
            }
            element.setCell(cp[i].getX(), cp[i].getY(), value);
            ++i;
        }
    }

    public boolean containsKey(String name) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (!this.core.isFix()) {
            throw new IOException("\u3053\u306e\u51e6\u7406\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u30d5\u30a3\u30c3\u30af\u30b9\u3057\u306a\u3044\u3068\u3001\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        return this.core.getCellPositionList().get(name) != null;
    }

    public byte[] getBytes() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.core.getExcelSheet().getBytes();
    }

    public void output(String name) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.core.getExcelSheet().output(name);
    }

    public ReportElement getElement() throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return new ReportElement(this.core.getExcelSheet());
    }

    public String getOutName() {
        return this.outName;
    }

    public boolean isUse() {
        return this.core != null;
    }
}

