/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.eval;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NameEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

final class ExternalFunction
implements FreeRefFunction {
    ExternalFunction() {
    }

    public ValueEval evaluate(Eval[] args, int srcCellRow, short srcCellCol, HSSFWorkbook workbook, HSSFSheet sheet) {
        FreeRefFunction targetFunc;
        int nIncomingArgs = args.length;
        if (nIncomingArgs < 1) {
            throw new RuntimeException("function name argument missing");
        }
        if (!(args[0] instanceof NameEval)) {
            throw new RuntimeException("First argument should be a NameEval, but got (" + args[0].getClass().getName() + ")");
        }
        NameEval functionNameEval = (NameEval)args[0];
        int nOutGoingArgs = nIncomingArgs - 1;
        Eval[] outGoingArgs = new Eval[nOutGoingArgs];
        System.arraycopy(args, 1, outGoingArgs, 0, nOutGoingArgs);
        try {
            targetFunc = this.findTargetFunction(workbook, functionNameEval);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return targetFunc.evaluate(outGoingArgs, srcCellRow, srcCellCol, workbook, sheet);
    }

    private FreeRefFunction findTargetFunction(HSSFWorkbook workbook, NameEval functionNameEval) throws EvaluationException {
        int numberOfNames = workbook.getNumberOfNames();
        int nameIndex = functionNameEval.getIndex();
        if (nameIndex < 0 || nameIndex >= numberOfNames) {
            throw new RuntimeException("Bad name index (" + nameIndex + "). Allowed range is (0.." + (numberOfNames - 1) + ")");
        }
        String functionName = workbook.getNameName(nameIndex);
        throw new EvaluationException(ErrorEval.FUNCTION_NOT_IMPLEMENTED);
    }
}

