/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;

public final class Countif
implements Function {
    public Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        switch (args.length) {
            case 2: {
                break;
            }
            default: {
                return ErrorEval.VALUE_INVALID;
            }
        }
        AreaEval range = (AreaEval)args[0];
        Eval criteriaArg = args[1];
        if (criteriaArg instanceof RefEval) {
            RefEval re = (RefEval)criteriaArg;
            criteriaArg = re.getInnerValueEval();
        }
        I_MatchPredicate mp = Countif.createCriteriaPredicate(criteriaArg);
        return this.countMatchingCellsInArea(range, mp);
    }

    private Eval countMatchingCellsInArea(AreaEval range, I_MatchPredicate criteriaPredicate) {
        ValueEval[] values = range.getValues();
        int result = 0;
        for (int i = 0; i < values.length; ++i) {
            if (!criteriaPredicate.matches(values[i])) continue;
            ++result;
        }
        return new NumberEval(result);
    }

    private static I_MatchPredicate createCriteriaPredicate(Eval evaluatedCriteriaArg) {
        if (evaluatedCriteriaArg instanceof NumberEval) {
            return new NumberMatcher(((NumberEval)evaluatedCriteriaArg).getNumberValue());
        }
        if (evaluatedCriteriaArg instanceof BoolEval) {
            return new BooleanMatcher(((BoolEval)evaluatedCriteriaArg).getBooleanValue());
        }
        if (evaluatedCriteriaArg instanceof StringEval) {
            return Countif.createGeneralMatchPredicate((StringEval)evaluatedCriteriaArg);
        }
        throw new RuntimeException("Unexpected type for criteria (" + evaluatedCriteriaArg.getClass().getName() + ")");
    }

    private static I_MatchPredicate createGeneralMatchPredicate(StringEval stringEval) {
        String value = stringEval.getStringValue();
        char firstChar = value.charAt(0);
        Boolean booleanVal = Countif.parseBoolean(value);
        if (booleanVal != null) {
            return new BooleanMatcher(booleanVal);
        }
        Double doubleVal = Countif.parseDouble(value);
        if (doubleVal != null) {
            return new NumberMatcher(doubleVal);
        }
        switch (firstChar) {
            case '<': 
            case '=': 
            case '>': {
                throw new RuntimeException("Incomplete code - criteria expressions such as '" + value + "' not supported yet");
            }
        }
        return new StringMatcher(value);
    }

    static Double parseDouble(String strRep) {
        double val;
        if (!Character.isDigit(strRep.charAt(0))) {
            return null;
        }
        try {
            val = Double.parseDouble(strRep);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return new Double(val);
    }

    static Boolean parseBoolean(String strRep) {
        switch (strRep.charAt(0)) {
            case 'T': 
            case 't': {
                if (!"TRUE".equalsIgnoreCase(strRep)) break;
                return Boolean.TRUE;
            }
            case 'F': 
            case 'f': {
                if (!"FALSE".equalsIgnoreCase(strRep)) break;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private static final class StringMatcher
    implements I_MatchPredicate {
        private final String _value;

        public StringMatcher(String value) {
            this._value = value;
        }

        public boolean matches(Eval x) {
            if (!(x instanceof StringEval)) {
                return false;
            }
            StringEval se = (StringEval)x;
            return se.getStringValue() == this._value;
        }
    }

    private static final class BooleanMatcher
    implements I_MatchPredicate {
        private final boolean _value;

        public BooleanMatcher(boolean value) {
            this._value = value;
        }

        public boolean matches(Eval x) {
            if (x instanceof StringEval) {
                StringEval se = (StringEval)x;
                Boolean val = Countif.parseBoolean(se.getStringValue());
                if (val == null) {
                    return false;
                }
                return false;
            }
            if (!(x instanceof BoolEval)) {
                return false;
            }
            BoolEval be = (BoolEval)x;
            return be.getBooleanValue() == this._value;
        }
    }

    private static final class NumberMatcher
    implements I_MatchPredicate {
        private final double _value;

        public NumberMatcher(double value) {
            this._value = value;
        }

        public boolean matches(Eval x) {
            if (x instanceof StringEval) {
                StringEval se = (StringEval)x;
                Double val = Countif.parseDouble(se.getStringValue());
                if (val == null) {
                    return false;
                }
                return val == this._value;
            }
            if (!(x instanceof NumberEval)) {
                return false;
            }
            NumberEval ne = (NumberEval)x;
            return ne.getNumberValue() == this._value;
        }
    }

    private static interface I_MatchPredicate {
        public boolean matches(Eval var1);
    }
}

