/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.UrlMask;
import org.maachang.comet.conf.UrlMaskList;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class HttpdAccessConfig {
    private static final String READ_FILE = "conf/access.conf";
    private static final String CHARSET = "UTF8";
    private static final long CHECK_TIME = 5000L;
    private static final Log LOG = LogFactory.getLog(HttpdAccessConfig.class);
    private String fileName = null;
    private final AtomicLONG lastUpdate = new AtomicLONG(-1L);
    private final AtomicLONG lastCheckTime = new AtomicLONG(-1L);
    private final AtomicOBJECT<UrlMaskList> masks = new AtomicOBJECT();

    public void open() throws Exception {
        this.open(READ_FILE);
    }

    public void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.lastUpdate.set(-1L);
        this.lastCheckTime.set(-1L);
        this.masks.set(null);
    }

    public boolean isUse() {
        return this.masks.get() != null;
    }

    public boolean isMask(String url, String address) {
        UrlMaskList mk;
        if (this.lastCheckTime.get() + 5000L <= System.currentTimeMillis()) {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate.get() != tm) {
                try {
                    this.reload();
                }
                catch (Exception e) {
                    LOG.error((Object)"\u30a2\u30af\u30bb\u30b9\u5236\u5fa1\u30c1\u30a7\u30c3\u30af\u4e2d\u306b\u30a8\u30e9\u30fc", (Throwable)e);
                    return true;
                }
            }
            this.lastCheckTime.set(System.currentTimeMillis());
        }
        if ((mk = (UrlMaskList)this.masks.get()) != null && mk.size() > 0) {
            return mk.isMask(url, address);
        }
        return true;
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config conf = new Config();
                ReadIni.analisys((Config)conf, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                if (this.createMasks(conf)) {
                    this.lastUpdate.set(last);
                }
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private final boolean createMasks(Config conf) {
        boolean ret = true;
        int i = 0;
        try {
            UrlMaskList mks = null;
            int len = conf.size("access", "url");
            int len2 = conf.size("access", "mask");
            if (len >= len2) {
                len = len2;
            }
            mks = new UrlMaskList();
            i = 0;
            while (i < len) {
                UrlMask mask = new UrlMask(conf.get("access", "url", i), conf.get("access", "mask", i));
                mks.add(mask);
                ++i;
            }
            this.masks.set((Object)mks);
        }
        catch (Exception e) {
            LOG.error((Object)("access.conf\u30a8\u30e9\u30fc(" + (i + 1) + ")"), (Throwable)e);
            ret = false;
        }
        return ret;
    }
}

