/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class MimeConfig {
    public static final String OPTION_GZIP = "gzip.";
    private static final String READ_FILE = "conf/mime.conf";
    private static final String CHARSET = "UTF8";
    private static final String BASE_SECTION = "mime-type";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private final AtomicOBJECT<Config> iniParams = new AtomicOBJECT();
    private final AtomicLONG lastUpdate = new AtomicLONG(-1L);
    private final AtomicOBJECT<String> fileName = new AtomicOBJECT();

    public void open() throws Exception {
        this.open(READ_FILE);
    }

    public void open(String name) throws Exception {
        this.fileName.set((Object)FileUtil.getFullPath((String)name));
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.iniParams.set(null);
        this.lastUpdate.set(-1L);
        this.fileName.set(null);
    }

    public String get(String name) {
        Config c = this.getConfig();
        if (c == null) {
            return DEFAULT_MIME_TYPE;
        }
        String ret = c.get(BASE_SECTION, name, 0);
        if (ret == null) {
            ret = DEFAULT_MIME_TYPE;
        }
        return ret;
    }

    public String getNameByMimeType(String name) {
        String ret;
        Config c = this.getConfig();
        if (c == null) {
            return DEFAULT_MIME_TYPE;
        }
        String plus = MimeConfig.getPlus(name);
        if (plus == null) {
            plus = name;
        }
        if ((ret = c.get(BASE_SECTION, plus, 0)) == null) {
            ret = DEFAULT_MIME_TYPE;
        }
        return ret;
    }

    private Config getConfig() {
        try {
            long tm = FileUtil.getLastTime((String)((String)this.fileName.get()));
            if (this.lastUpdate.get() != tm) {
                this.reload();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Config)this.iniParams.get();
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        String fname = (String)this.fileName.get();
        if (FileUtil.isFileExists((String)fname)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fname), CHARSET));
                Config conf = new Config();
                ReadIni.analisys((Config)conf, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)fname);
                this.iniParams.set((Object)conf);
                this.lastUpdate.set(last);
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static final String getPlus(String name) {
        int p = name.lastIndexOf(".");
        if (p == -1) {
            return null;
        }
        return name.substring(p + 1, name.length());
    }

    public String toString() {
        Config c = this.getConfig();
        if (c != null) {
            return c.toString();
        }
        return "null";
    }
}

