/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class PackagesConfig {
    private static final String BASE_SECTION = "import-package";
    private static final String CHARSET = "UTF8";
    private static final String READ_FILE = "conf/packages.conf";
    private String fileName = null;
    private final AtomicOBJECT<Config> iniParams = new AtomicOBJECT();
    private final AtomicOBJECT<String[]> packages = new AtomicOBJECT();
    private final AtomicLONG lastUpdate = new AtomicLONG(-1L);
    private final AtomicINT updateId = new AtomicINT(0);

    public void open() throws Exception {
        this.open(READ_FILE);
    }

    public void open(String name) throws Exception {
        this.fileName = FileUtil.getFullPath((String)name);
        try {
            this.reload();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.iniParams.set(null);
        this.packages.set(null);
        this.lastUpdate.set(-1L);
        this.updateId.set(0);
    }

    public String[] getPackages() throws Exception {
        this.updateByReload();
        if (this.iniParams.get() == null) {
            return null;
        }
        if (this.packages.get() != null) {
            return (String[])this.packages.get();
        }
        String[] ret = ((Config)this.iniParams.get()).getAll(BASE_SECTION, "package");
        if (ret != null && ret.length > 0) {
            int len = ret.length;
            int i = 0;
            while (i < len) {
                if (ret[i] == null || (ret[i] = ret[i].trim()).length() <= 0) {
                    ret[i] = null;
                } else if (!ret[i].startsWith("var ")) {
                    ret[i] = "var " + ret[i] + " = Packages." + ret[i] + ";";
                }
                ++i;
            }
        }
        this.packages.set((Object)ret);
        return ret;
    }

    public int getUpdateId() {
        this.updateByReload();
        return this.updateId.get();
    }

    private final void reload() throws Exception {
        BufferedReader buf = null;
        if (FileUtil.isFileExists((String)this.fileName)) {
            try {
                buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.fileName), CHARSET));
                Config iniParams = new Config();
                ReadIni.analisys((Config)iniParams, (BufferedReader)buf);
                buf.close();
                buf = null;
                long last = FileUtil.getLastTime((String)this.fileName);
                this.iniParams.set((Object)iniParams);
                this.lastUpdate.set(last);
            }
            finally {
                if (buf != null) {
                    try {
                        buf.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void updateByReload() {
        try {
            long tm = FileUtil.getLastTime((String)this.fileName);
            if (this.lastUpdate.get() != tm) {
                this.reload();
                this.packages.set(null);
                this.updateId.inc();
                if (this.updateId.get() >= 10000) {
                    this.updateId.set(0);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

