/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import org.maachang.util.NetMask;

class UrlMask {
    private NetMask mask = null;
    private String url = null;

    private UrlMask() {
    }

    public UrlMask(String url, String mask) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0 || mask == null || (mask = mask.trim()).length() <= 0 || mask.indexOf("/") == -1) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!url.startsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        NetMask m = new NetMask(mask);
        this.url = url;
        this.mask = m;
    }

    public boolean isUrl(String url) {
        if (url == null || url.length() <= 0) {
            return false;
        }
        return url.startsWith(this.url);
    }

    public boolean isMask(String ipAddress) {
        if (ipAddress == null || ipAddress.length() <= 0) {
            return false;
        }
        return this.mask.isRange(ipAddress);
    }

    public String getUrl() {
        return this.url;
    }
}

