/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.util.Iterator;
import java.util.Map;
import org.maachang.comet.httpd.engine.PublicCacheChild;
import org.maachang.util.FileUtil;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PublicCacheChildThread
extends LoopThread {
    private Map<String, PublicCacheChild> manager = null;

    public PublicCacheChildThread(Map<String, PublicCacheChild> manager) throws Exception {
        this.manager = manager;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.manager = null;
    }

    protected boolean execution() throws Exception {
        Iterator<String> itr = this.manager.keySet().iterator();
        while (itr.hasNext()) {
            if (super.isStop()) break;
            Thread.sleep(100L);
            String key = itr.next();
            PublicCacheChild ch = this.manager.get(key);
            if (ch == null) continue;
            long time = -1L;
            if (!FileUtil.isFileExists((String)ch.getPath())) {
                itr.remove();
                continue;
            }
            if (ch.getUpdateTime() <= System.currentTimeMillis()) {
                itr.remove();
                continue;
            }
            time = FileUtil.getLastTime((String)ch.getPath());
            if (time == ch.getLastUpdateTime()) continue;
            byte[] bin = FileUtil.getFile((String)ch.getPath());
            ch.set(bin, time);
        }
        return false;
    }
}

