/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.errors.HttpdErrorPageManager;
import org.maachang.manager.GlobalManager;

public class WriteError {
    public static final void output(HttpdRequest request, HttpdResponse response, HttpdHeaders header, int state, String detail) throws Exception {
        try {
            byte[] bin = WriteError.getErrorPage(request.getUrlPath(), state, detail);
            if (bin != null) {
                HttpdResponse res = response.create(request, request.getUrlPath(), state, request.getKeepAliveTimeout(), request.getKeepAliveCount());
                res.setHttpCache(true);
                res.setHttpClose(true);
                res.setGzip(true);
                res.setCookieSession(request);
                int len = bin.length;
                if (header != null) {
                    res.getHeader().add(header);
                }
                res.getHeader().addHeader("Content-Type", "text/html; charset=utf-8");
                res.getOutput().write(bin, 0, len);
                res.flush();
                res.flushAndClose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final byte[] getErrorPage(String url, int code, String detail) {
        HttpdErrorPageManager errors = (HttpdErrorPageManager)GlobalManager.getValue((String)"ERROR_PAGE_MANAGER");
        byte[] ret = null;
        String error = null;
        try {
            error = errors.getErrorPage(url, code, HttpdErrorDef.convertErrorMessage(code), detail);
            if (error != null) {
                try {
                    ret = error.getBytes("UTF-8");
                }
                catch (Exception ee) {
                    error = null;
                    ret = null;
                }
            }
        }
        catch (Exception e) {
            error = null;
            ret = null;
        }
        if (ret == null) {
            try {
                error = errors.getDefaultErrorPage(url, code, HttpdErrorDef.convertErrorMessage(code), detail);
                if (error != null) {
                    ret = error.getBytes("UTF-8");
                }
            }
            catch (Exception e) {
                error = null;
                ret = null;
            }
        }
        if (ret == null) {
            return null;
        }
        return ret;
    }
}

