/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.io.IOException;
import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.engine.comet.CometConnectQueue;
import org.maachang.comet.httpd.engine.comet.ConnectComet;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.EndScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.comet.httpd.engine.script.scripts.ApplicationScriptFactory;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.net.HttpdResponseImpl;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.jsr.script.javascript.RhinoSimpleScriptContext;
import org.maachang.manager.GlobalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comet {
    private static final Log LOG = LogFactory.getLog(Comet.class);
    private String groupId = null;
    private String scriptPath = null;
    private CometConnectQueue<ConnectComet> connects = null;
    private long createTime = -1L;
    private long updateTime = -1L;
    private final HttpdResponseImpl response = new HttpdResponseImpl();
    private final Object sync = new Object();

    private Comet() {
    }

    public Comet(String groupId, String scriptPath) throws Exception {
        if (groupId == null || (groupId = groupId.trim()).length() <= 0 || scriptPath == null || (scriptPath = scriptPath.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.groupId = groupId;
        this.scriptPath = scriptPath;
        this.createTime = System.currentTimeMillis();
        this.updateTime = System.currentTimeMillis();
        this.connects = new CometConnectQueue();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.sync;
        synchronized (object) {
            Comet.destroyConnection(this.connects);
            this.groupId = null;
            this.scriptPath = null;
            this.createTime = -1L;
            this.updateTime = -1L;
            this.connects = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putConnection(HttpdRequest request) throws Exception {
        if (request == null || !request.isUse()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            if (this.connects == null) {
                return;
            }
            ConnectComet conn = new ConnectComet(request);
            this.connects.add(conn);
            this.updateTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanConnection() throws Exception {
        int len = 0;
        Object object = this.sync;
        synchronized (object) {
            if (this.connects == null) {
                return;
            }
            len = this.connects.size();
        }
        int i = len - 1;
        while (i >= 0) {
            Object object2 = this.sync;
            synchronized (object2) {
                try {
                    ConnectComet conn;
                    if (this.connects.size() > i && (conn = this.connects.get(i)) != null && !conn.isConnection()) {
                        conn.destroy();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Thread.sleep(1L);
            --i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Object args, String groupId) throws Exception {
        String scPath;
        CometConnectQueue<ConnectComet> conns = this.getNowCometConnects();
        if (conns == null || conns.size() <= 0) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            scPath = this.scriptPath;
        }
        Comet.sendAll(this.response, conns, scPath, args, groupId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... exit - comet:" + groupId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getConnectSessionIds(List<String> out) {
        if (out == null) {
            return;
        }
        out.clear();
        Object object = this.sync;
        synchronized (object) {
            if (this.connects == null) {
                return;
            }
            int len = this.connects.size();
            int i = len - 1;
            while (i >= 0) {
                try {
                    ConnectComet conn = this.connects.get(i);
                    if (conn != null && conn.isConnection()) {
                        HttpdSession session = conn.getRequest().getSession();
                        if (session != null && session.getSessionId() != null) {
                            out.add(session.getSessionId());
                        }
                    } else {
                        if (conn != null) {
                            conn.destroy();
                        }
                        this.connects.remove(i);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectSize() {
        Object object = this.sync;
        synchronized (object) {
            if (this.connects != null) {
                return this.connects.size();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroupId() {
        Object object = this.sync;
        synchronized (object) {
            return this.groupId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getScriptPath() {
        Object object = this.sync;
        synchronized (object) {
            return this.scriptPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreateTime() {
        Object object = this.sync;
        synchronized (object) {
            return this.createTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUpdateTime() {
        long ret = -1L;
        Object object = this.sync;
        synchronized (object) {
            ret = this.updateTime;
        }
        return ret;
    }

    public static final Object oneSend(HttpdResponse res, BaseModel baseModel, HttpdRequest request, String scriptPath, String groupId) throws Exception {
        return Comet.oneSend(res, baseModel, request, scriptPath, null, groupId);
    }

    public static final Object oneSend(HttpdResponse res, BaseModel baseModel, HttpdRequest request, String scriptPath, Object args, String groupId) throws Exception {
        Object ret;
        block19: {
            ApplicationScriptFactory webapp = (ApplicationScriptFactory)GlobalManager.getValue((String)"WEBAPP_FACTORY");
            if (webapp == null) {
                throw new IOException("WebAppScriptFactory\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            Script comet = webapp.getApplication(scriptPath);
            if (comet == null) {
                throw new IOException("[" + scriptPath + "]\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            ret = null;
            RhinoSimpleScriptContext ctx = null;
            boolean errorFlag = false;
            try {
                try {
                    ctx = new RhinoSimpleScriptContext();
                    CacheScriptManager.getInstance().script();
                    ScriptDef.setDirectoryByBindings((ScriptContext)ctx);
                    Bindings bindings = ctx.getBindings(100);
                    bindings.put("_$script$query", (Object)ScriptDef.getQuery(request.getQuery()));
                    bindings.put("__$type$script", (Object)"comet");
                    bindings.put("_$script$base_model", (Object)baseModel);
                    bindings.put("_$script$path", (Object)scriptPath);
                    bindings.put("_$script$header", (Object)request.getHeader());
                    bindings.put("_$script$comet_args", args);
                    bindings.put("_$script$group_id", (Object)groupId);
                    HttpdSession session = request.getSession();
                    if (session != null) {
                        bindings.put("_$script$session", (Object)session);
                    }
                    if (res != null) {
                        res.setHttpCache(true);
                        res.setHttpClose(false);
                        res.setCookieSession(request);
                        res.getHeader().setHeader("Content-Type", "text/xml; charset=utf-8");
                        res.setHttpCache(true);
                        bindings.put("_$script$request", (Object)request);
                        bindings.put("_$script$response", (Object)res);
                    }
                    comet.getScript().execution((ScriptContext)ctx, null);
                    if (res != null) {
                        res.flush();
                    }
                }
                catch (ScriptException sc) {
                    if (ctx != null && EndScript.isEndScript(sc)) {
                        ret = EndScript.getEndByResult((ScriptContext)ctx);
                        break block19;
                    }
                    LOG.warn((Object)"error", (Throwable)sc);
                    errorFlag = true;
                    throw sc;
                }
                catch (Exception e) {
                    LOG.warn((Object)"error", (Throwable)e);
                    errorFlag = true;
                    throw e;
                }
            }
            finally {
                if (baseModel.isCreate()) {
                    try {
                        if (errorFlag) {
                            baseModel.rollback();
                        } else {
                            baseModel.commit();
                        }
                    }
                    catch (Exception exception) {}
                }
                CacheScriptManager.getInstance().exitScript();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CometConnectQueue<ConnectComet> getNowCometConnects() {
        Object object = this.sync;
        synchronized (object) {
            if (this.connects != null) {
                CometConnectQueue<ConnectComet> ret = this.connects;
                this.connects = new CometConnectQueue();
                this.updateTime = System.currentTimeMillis();
                return ret;
            }
            return null;
        }
    }

    private static void sendAll(HttpdResponseImpl response, CometConnectQueue<ConnectComet> conns, String scriptPath, Object args, String groupId) throws Exception {
        BaseModelImpl baseModel = new BaseModelImpl();
        int len = conns.size();
        int i = 0;
        while (i < len) {
            ConnectComet conn = conns.remove();
            if (conn == null || !conn.isConnection()) {
                if (conn != null) {
                    conn.destroy();
                }
            } else {
                try {
                    try {
                        response.create(conn.getRequest(), conn.getRequest().getUrlPath(), 200, conn.getRequest().getKeepAliveTimeout(), conn.getRequest().getKeepAliveCount());
                        Comet.oneSend(response, baseModel, conn.getRequest(), scriptPath, args, groupId);
                        response.flush();
                        response.flushAndClose();
                        ConnectionInfo info = conn.getConnectionInfo();
                        try {
                            if (info != null && info.isUse()) {
                                if (info.isCloseFlag()) {
                                    info.destroy();
                                } else if (info.getCount() > 0 && info.recyclingConnection()) {
                                    conn.cancel();
                                }
                            } else if (info != null) {
                                info.destroy();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        conn.cancel();
                    }
                    catch (Exception e) {
                        if (conn != null) {
                            conn.destroy();
                        }
                        LOG.error((Object)"comet-error", (Throwable)e);
                    }
                }
                finally {
                    response.clear();
                }
            }
            ++i;
        }
    }

    private static final void destroyConnection(CometConnectQueue<ConnectComet> conns) {
        if (conns != null) {
            int len = conns.size();
            int i = 0;
            while (i < len) {
                ConnectComet con = conns.remove();
                if (con != null) {
                    con.destroy();
                }
                ++i;
            }
            conns.clear();
        }
    }
}

