/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.comet.Comet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CometMonitor
extends Thread {
    private static final Log LOG = LogFactory.getLog(CometMonitor.class);
    private static final long TIME = 5000L;
    private Map<String, Comet> manager = null;
    private long beforeTime = System.currentTimeMillis();
    private volatile boolean stopFlag = false;
    private Object stopSync = new Object();
    private static final long IDLE_TIME = 1000L;

    public CometMonitor(Map<String, Comet> manager) {
        this.manager = manager;
        this.setDaemon(true);
        this.start();
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public void clear() {
        this.stopThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStopThread() {
        boolean ret = false;
        Object object = this.stopSync;
        synchronized (object) {
            ret = this.stopFlag;
        }
        return ret;
    }

    @Override
    public void run() {
        block21: {
            block16: while (true) {
                while (true) {
                    if (this.isStopThread()) {
                        break block21;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (this.beforeTime + 5000L > System.currentTimeMillis()) continue block16;
                        try {
                            if (this.manager == null || this.manager.size() <= 0) continue block16;
                            Iterator<String> it = this.manager.keySet().iterator();
                            while (true) {
                                if (!it.hasNext()) continue block16;
                                try {
                                    String key = it.next();
                                    if (this.isStopThread()) continue block16;
                                    Comet comet = this.manager.get(key);
                                    if (comet == null) {
                                        this.manager.remove(key);
                                        continue;
                                    }
                                    comet.cleanConnection();
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException iee) {
                                    throw iee;
                                }
                                catch (Exception ee) {
                                    LOG.error((Object)"error", (Throwable)ee);
                                }
                            }
                        }
                        finally {
                            this.beforeTime = System.currentTimeMillis();
                            continue block16;
                        }
                    }
                    catch (InterruptedException ie) {
                        break block21;
                    }
                    catch (OutOfMemoryError mm) {
                        LOG.error((Object)"OutOfMemoryError", (Throwable)mm);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            finally {
                LOG.warn((Object)("## stopThread:" + this.getClass().getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopThread() {
        Object object = this.stopSync;
        synchronized (object) {
            this.stopFlag = true;
        }
    }
}

