/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.util.Iterator;
import java.util.Map;
import org.maachang.comet.httpd.engine.script.DirLock;
import org.maachang.comet.httpd.engine.script.FileListChild;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DestroyFileListThread
extends LoopThread {
    private long destroyTime = -1L;
    private Map<String, FileListChild> manager = null;
    private DirLock sync = null;

    private DestroyFileListThread() {
    }

    public DestroyFileListThread(long destroyTime, Map<String, FileListChild> manager, DirLock sync) throws Exception {
        this.destroyTime = destroyTime;
        this.manager = manager;
        this.sync = sync;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
    }

    protected boolean execution() throws Exception {
        Iterator<String> it = this.manager.keySet().iterator();
        long now = System.currentTimeMillis();
        while (it.hasNext()) {
            if (super.isStop()) break;
            String key = it.next();
            if (key != null) {
                this.sync.lock(key);
                try {
                    try {
                        FileListChild ch = this.manager.get(key);
                        if (ch == null) {
                            it.remove();
                        } else if (ch.getLastAccess() + this.destroyTime <= now) {
                            it.remove();
                        }
                    }
                    catch (Exception exception) {}
                }
                finally {
                    this.sync.unlock(key);
                }
            }
            Thread.sleep(100L);
            now += 100L;
        }
        return false;
    }
}

