/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptDef {
    public static final String SCRIPT_BY_LOG = "log";
    public static final String SCRIPT_MODE = "__$type$script";
    public static final String SCRIPT_DETAIL = "__$detail$script";
    public static final String CURRENT_SCRIPT = "_$current$name";
    public static final String MODE_COMET = "comet";
    public static final String MODE_NOT_COMET = "script";
    public static final String MODE_CONSOLE = "console";
    public static final String MANAGER = "_$$maachang_comet_manager";
    public static final String SCRIPT_BY_MODEL = "_$script$base_model";
    public static final String SCRIPT_BY_ENGINE = "_$script$engine";
    public static final String SCRIPT_BY_CTX = "_$script$context";
    public static final String SCRIPT_BY_SESSION = "_$script$session";
    public static final String SCRIPT_BY_HEADER = "_$script$header";
    public static final String SCRIPT_BY_PATH = "_$script$path";
    public static final String SCRIPT_BY_GROUP_ID = "_$script$group_id";
    public static final String SCRIPT_BY_COMET_ARGS = "_$script$comet_args";
    public static final String SCRIPT_BY_RESPONSE = "_$script$response";
    public static final String SCRIPT_BY_REQUEST = "_$script$request";
    public static final String SCRIPT_BY_QUERY = "_$script$query";
    public static final String SCRIPT_CACHE_DB = "_$cachedb$params";
    public static final String SCRIPT_SHARED = "_$shared$params";
    public static final String SCRIPT_LAST_MHTML = "_$script$lastMHTML";
    public static final String SCRIPT_LAST_CONTROLLER = "_$script$controllerName";
    public static final String ENGINE_JAVASCRIPT = "jss";
    public static final String SCRIPT_RESULT_REDIRECT = "redirect";
    public static final String SCRIPT_RESULT_FORWARD = "forward";
    public static final String SCRIPT_RESULT_ERROR = "error";
    public static final String EXIT_FOODER = "exit() ;\n";

    private ScriptDef() {
    }

    public static final String trimCurrentDirectory(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        directory = FileUtil.getFullPath((String)directory);
        if (!(directory = StringUtil.changeString((String)directory, (String)"\\", (String)"/")).startsWith("/")) {
            directory = "/" + directory;
        }
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        return directory;
    }

    public static final String convertApplicationName(String path, String name) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0 || name == null || (name = name.trim()).length() <= 0) {
            throw new HttpdStateException(404, "\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name.startsWith("/")) {
            return name;
        }
        if (name.startsWith("\\")) {
            return StringUtil.changeString((String)name, (String)"\\", (String)"/");
        }
        if (path.startsWith("\\") || path.startsWith("/")) {
            path = path.substring(1, path.length());
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = String.valueOf(path) + "/";
        }
        if (name.startsWith("\\") || name.startsWith("/")) {
            name = name.substring(1, name.length());
        }
        if (path.startsWith("\\") || path.startsWith("/")) {
            path = "." + path;
        }
        String fullPath = FileUtil.getFullPath((String)".");
        String params = "";
        int p = name.indexOf("?");
        if (p != -1) {
            params = name.substring(p);
            name = name.substring(0, p);
        }
        String file = FileUtil.getFileName((String)name);
        String target = FileUtil.getFullPath((String)(String.valueOf(path) + name));
        if (fullPath.length() > target.length()) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u540d[" + name + "]\u306e\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        target = target.substring(fullPath.length(), target.length());
        fullPath = null;
        if (!target.endsWith(file)) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u540d[" + name + "]\u306e\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return String.valueOf(StringUtil.changeString((String)target, (String)"\\", (String)"/")) + params;
    }

    public static String getScriptByResource(String path) throws Exception {
        return ScriptDef.getScriptByResource(path, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScriptByResource(String path, String src, String dest) throws Exception {
        StringBuilder buf;
        BufferedReader br;
        block14: {
            String s;
            block13: {
                String s2;
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                br = null;
                buf = new StringBuilder();
                br = new BufferedReader(new InputStreamReader(cl.getResourceAsStream(path), "UTF8"));
                if (src == null || dest == null) break block13;
                while ((s2 = br.readLine()) != null) {
                    s2 = StringUtil.changeString((String)s2, (String)src, (String)dest);
                    buf.append(s2);
                    buf.append("\r\n");
                }
                break block14;
            }
            while ((s = br.readLine()) != null) {
                buf.append(s);
                buf.append("\r\n");
            }
        }
        br.close();
        br = null;
        return buf.toString();
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final String getScriptManagerCode(String[] scripts, String currentDirectory) throws Exception {
        if (scripts != null && scripts.length > 0) {
            StringBuilder buf = new StringBuilder();
            int len = scripts.length;
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(":");
                }
                if (scripts[i].startsWith("/") || scripts[i].startsWith("\\")) {
                    scripts[i] = scripts[i].substring(1);
                }
                buf.append(scripts[i]);
                long time = FileUtil.getLastTime((String)(String.valueOf(currentDirectory) + scripts[i]));
                buf.append("-").append(time);
                ++i;
            }
            byte[] bin = buf.toString().getBytes("UTF8");
            buf = null;
            return Digest.convert((String)"SHA1", (byte[])bin);
        }
        return null;
    }

    public static final String[] getUseScript(String dir) throws Exception {
        ArrayList<String> lst = new ArrayList<String>();
        ScriptDef.list(lst, dir, dir);
        if (lst.size() > 0) {
            int len = lst.size();
            Object[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = lst.get(i);
                ++i;
            }
            lst = null;
            Arrays.sort(ret);
            return ret;
        }
        return null;
    }

    private static final void list(ArrayList<String> out, String base, String dir) throws Exception {
        File fp = new File(dir);
        String[] names = fp.list();
        fp = null;
        if (names != null && names.length > 0) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                if (names[i] != null && (names[i] = names[i].trim()).length() > 0) {
                    String name = dir + FileUtil.FILE_SPACE + names[i];
                    if (FileUtil.isDirExists((String)name)) {
                        ScriptDef.list(out, base, name);
                    } else if (name.toLowerCase().endsWith(".ms")) {
                        if ((name = name.substring(base.length(), name.length())).indexOf("\\") != -1) {
                            name = StringUtil.changeString((String)name, (String)"\\", (String)"/");
                        }
                        if (name.startsWith("/")) {
                            name.substring(1, name.length());
                        }
                        out.add(name);
                    }
                }
                ++i;
            }
        }
    }

    public static final void setDirectoryByBindings(ScriptContext ctx) throws Exception {
        if (ctx == null) {
            return;
        }
        ScriptDef.setDirectoryByBindings(ctx.getBindings(100));
    }

    public static final void setDirectoryByBindings(Bindings bindings) throws Exception {
        if (bindings == null) {
            return;
        }
        String current = ScriptDef.trimCurrentDirectory(".");
        bindings.put("_$path$currentPath", (Object)current);
        bindings.put("_$path$scriptPath", (Object)(String.valueOf(current) + "application/"));
        bindings.put("_$path$modelPath", (Object)(String.valueOf(current) + "model/"));
    }

    public static final Map<String, Object> getQuery(HttpdParams params) {
        if (params == null) {
            return new HashMap<String, Object>();
        }
        return params.getPrivateMap();
    }
}

