/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cron;

import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.BaseModel;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptManager;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.javascript.RhinoSimpleScriptContext;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public class CronScript {
    private static final Log LOG = LogFactory.getLog(CronScript.class);
    protected static final String ENGINE_NAME = "js";
    protected static final String DETAIL_NAME = "cron";
    protected static final String CRON_NAME = "Cron";

    private CronScript() {
    }

    public static final void execution(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name.endsWith(".ms")) {
            name = name.substring(0, name.length() - ".ms".length());
        }
        if (name.endsWith(CRON_NAME)) {
            name = name.substring(0, name.length() - CRON_NAME.length());
        }
        CronScript.executionScript(CronScript.getScriptEngine(), String.valueOf(name) + CRON_NAME + ".ms");
    }

    private static final boolean executionScript(ScriptEngine engine, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            return false;
        }
        if (name.startsWith("/") || name.startsWith("\\")) {
            name = name.substring(1);
        }
        name = StringUtil.changeString((String)name, (String)"\\", (String)"/");
        String file = FileUtil.getFullPath((String)("." + (name = "/cron/" + name)));
        if (!FileUtil.isFileExists((String)file) || !FileUtil.isRead((String)file)) {
            return false;
        }
        String script = FileUtil.getFileByString((String)file, (String)"UTF8");
        ApiManager.setScriptName((String)name);
        BaseModel baseModel = null;
        boolean errorFlag = false;
        try {
            try {
                RhinoSimpleScriptContext ctx = new RhinoSimpleScriptContext();
                CacheScriptManager.getInstance().script();
                Bindings bindings = CronScript.putBindings((ScriptContext)ctx);
                baseModel = new BaseModelImpl();
                bindings.put("_$script$base_model", (Object)baseModel);
                bindings.put("_$script$context", (Object)ctx);
                bindings.put("_$script$engine", (Object)engine);
                engine.eval(script, bindings);
            }
            catch (Exception e) {
                errorFlag = true;
                throw e;
            }
        }
        finally {
            if (baseModel != null && baseModel.isCreate()) {
                try {
                    if (errorFlag) {
                        baseModel.rollback();
                    } else {
                        baseModel.commit();
                    }
                }
                catch (Exception exception) {}
            }
            CacheScriptManager.getInstance().exitScript();
        }
        return true;
    }

    private static final ScriptEngine getScriptEngine() throws Exception {
        ScriptEngine engine = ApiManager.getInstance().getScriptEngine();
        return engine;
    }

    private static final Bindings putBindings(ScriptContext ctx) throws Exception {
        Bindings bindings = ctx.getBindings(100);
        bindings.put("_$current$name", (Object)DETAIL_NAME);
        bindings.put("__$type$script", (Object)"script");
        bindings.put("__$detail$script", (Object)DETAIL_NAME);
        bindings.put("_$$maachang_comet_manager", (Object)GlobalManager.getInstance());
        bindings.put("log", (Object)LOG);
        return bindings;
    }
}

