/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public abstract class AbstractScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected String type = null;
    protected final AtomicLONG updateTime = new AtomicLONG(-1L);
    protected final AtomicOBJECT<SrcScript> srcScript = new AtomicOBJECT();
    protected final AtomicINT packageId = new AtomicINT(-1);
    protected final AtomicOBJECT<ExecutionScript> executionScript = new AtomicOBJECT();

    public ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            throw new HttpdStateException(500, "\u5bfe\u8c61" + this.type + "\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript.get() == null || this.updateTime.get() != FileUtil.getLastTime((String)this.fileName) || this.packageId.get() != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return (ExecutionScript)this.executionScript.get();
    }

    protected void clear() {
        this.updateTime.set(-1L);
        this.srcScript.set(null);
        this.packageId.set(-1);
        this.executionScript.set(null);
    }

    public String getPath() {
        return this.path;
    }

    public String getScriptName() {
        return this.fileName;
    }

    public abstract int getScriptType();

    public SrcScript getSrcScript() {
        return (SrcScript)this.srcScript.get();
    }

    public boolean isScript() {
        return this.executionScript.get() != null;
    }

    protected abstract String addHeaderScript() throws Exception;

    protected abstract String addFooterScript() throws Exception;

    protected void create(String type, String baseDirectory, String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            this.clear();
            throw new HttpdStateException(404, String.valueOf(type) + "\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + baseDirectory + path))) {
            this.clear();
            throw new HttpdStateException(404, "\u5bfe\u8c61" + type + "\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (path.endsWith(".ms")) {
            path = path.substring(0, path.length() - ".ms".length());
        }
        this.path = path;
        this.type = type;
        this.fileName = fileName;
    }

    protected void readScript() throws Exception {
        String script = null;
        String header = this.addHeaderScript();
        String footer = this.addFooterScript();
        int pid = -1;
        if (header == null && footer == null) {
            StringBuilder buf = new StringBuilder();
            pid = JsDef.pushDefaultPackage(buf);
            String s = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
            if (s == null) {
                this.executionScript.set(null);
                this.updateTime.set(-1L);
                return;
            }
            buf.append(s);
            s = null;
            script = buf.toString();
        } else {
            String s;
            StringBuilder buf = new StringBuilder();
            pid = JsDef.pushDefaultPackage(buf);
            if (header != null) {
                buf.append(header).append("\n");
            }
            if ((s = FileUtil.getFileByString((String)this.fileName, (String)"UTF8")) == null) {
                this.executionScript.set(null);
                this.updateTime.set(-1L);
                return;
            }
            buf.append(s);
            s = null;
            if (footer != null) {
                buf.append("\n").append(footer);
            }
            script = buf.toString();
            buf = null;
        }
        this.srcScript.set((Object)new SrcScript(script));
        script = ReadScriptPlus.convert(true, script);
        this.executionScript.set((Object)new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script));
        script = null;
        this.updateTime.set(FileUtil.getLastTime((String)this.fileName));
        this.packageId.set(pid);
    }
}

