/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class EtcScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected final AtomicLONG updateTime = new AtomicLONG(-1L);
    private final AtomicOBJECT<SrcScript> srcScript = new AtomicOBJECT();
    protected final AtomicOBJECT<ExecutionScript> executionScript = new AtomicOBJECT();
    private final AtomicINT packageId = new AtomicINT(-1);

    public EtcScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u30b9\u30af\u30ea\u30d7\u30c8\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + path))) {
            throw new HttpdStateException(500, "\u6307\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path.substring(0, path.length() - ".ms".length());
        this.fileName = fileName;
    }

    protected void clear() {
        this.updateTime.set(-1L);
        this.srcScript.set(null);
        this.executionScript.set(null);
        this.packageId.set(-1);
    }

    public ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            this.clear();
        } else if (this.executionScript.get() == null || this.updateTime.get() != FileUtil.getLastTime((String)this.fileName) || this.packageId.get() != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return (ExecutionScript)this.executionScript.get();
    }

    public String getPath() {
        return this.path;
    }

    public String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 99;
    }

    public SrcScript getSrcScript() {
        return (SrcScript)this.srcScript.get();
    }

    public boolean isScript() {
        return this.executionScript.get() != null;
    }

    protected void readScript() throws Exception {
        StringBuilder buf = new StringBuilder();
        int pid = JsDef.pushDefaultPackage(buf);
        String s = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
        if (s == null) {
            this.executionScript.set(null);
            this.updateTime.set(-1L);
            return;
        }
        buf.append(s);
        String script = buf.toString();
        buf = null;
        script = ReadScriptPlus.convert(true, script);
        this.srcScript.set((Object)new SrcScript(script));
        this.executionScript.set((Object)new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script));
        script = null;
        this.updateTime.set(FileUtil.getLastTime((String)this.fileName));
        this.packageId.set(pid);
    }
}

