/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.InitJS;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.PageCache;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScriptAnalysis;
import org.maachang.comet.httpd.engine.script.taglib.AnalysisTagLib;
import org.maachang.util.FileUtil;
import org.maachang.util.atomic.AtomicINT;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.AtomicOBJECT;

public class InnerScript
implements Script {
    protected String path = null;
    protected String fileName = null;
    protected final AtomicLONG updateTime = new AtomicLONG(-1L);
    protected final AtomicOBJECT<ExecutionScriptImpl> executionScript = new AtomicOBJECT();
    private final AtomicOBJECT<SrcScript> srcScript = new AtomicOBJECT();
    private final AtomicINT packageId = new AtomicINT(-1);

    private InnerScript() {
    }

    public InnerScript(String path, String currentDirectory) throws Exception {
        String fileName;
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!path.endsWith(".ms")) {
            path = String.valueOf(path) + ".ms";
        }
        if (!FileUtil.isFileExists((String)(fileName = (currentDirectory = ScriptDef.trimCurrentDirectory(currentDirectory)) + "application/" + (path.startsWith("/") ? path.substring(1, path.length()) : path)))) {
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a4\u30f3\u30ca\u30fc\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path;
        this.fileName = fileName;
    }

    protected void clear() {
        this.packageId.set(-1);
        this.updateTime.set(-1L);
        this.srcScript.set(null);
        this.executionScript.set(null);
    }

    public ExecutionScript getScript() throws Exception {
        if (!FileUtil.isFileExists((String)this.fileName)) {
            this.clear();
            throw new HttpdStateException(500, "\u5bfe\u8c61\u30a4\u30f3\u30ca\u30fc\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript.get() == null || this.updateTime.get() != FileUtil.getLastTime((String)this.fileName) || this.packageId.get() != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return (ExecutionScript)this.executionScript.get();
    }

    public String getPath() {
        return this.path;
    }

    public String getScriptName() {
        return this.fileName;
    }

    public int getScriptType() {
        return 31;
    }

    public SrcScript getSrcScript() {
        return (SrcScript)this.srcScript.get();
    }

    public boolean isScript() {
        return this.executionScript.get() != null;
    }

    protected void readScript() throws Exception {
        StringBuilder buf;
        String script = FileUtil.getFileByString((String)this.fileName, (String)"UTF8");
        if (script == null) {
            this.executionScript.set(null);
            this.updateTime.set(-1L);
            return;
        }
        String[] sc = new String[]{script};
        long tm = PageCache.getInstance().analysisCacheMode(sc);
        if (tm > 0L) {
            script = sc[0];
            sc = null;
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis("_$cache$inner.ad", script);
            buf = new StringBuilder();
            buf.append("var _$cache$inner = new StrBuf() ;\n");
            buf.append(script);
            buf.append("var _$cache$inner$out = _$cache$inner.ts() ;\n_$cache$inner.clear();\n_$cache$inner=null;\n").append("org.maachang.comet.httpd.engine.script.scripts.PageCache.getInstance().set( \"").append("@inner@").append(this.path).append("\",").append(tm).append(",_$cache$inner$out ) ;\n").append("httpPrint( _$cache$inner$out ) ;\n");
            script = buf.toString();
            buf = null;
        } else {
            sc = null;
            script = AnalysisTagLib.analysis(script);
            script = TemplateScriptAnalysis.analysis(script);
        }
        buf = new StringBuilder();
        int pid = JsDef.pushDefaultPackage(buf);
        buf.append(InitJS.getInstance().get());
        buf.append(script);
        script = buf.toString();
        buf = null;
        this.srcScript.set((Object)new SrcScript(script));
        script = ReadScriptPlus.convert(true, script);
        this.executionScript.set((Object)new ExecutionScriptImpl("jss", this.getScriptType(), this.getPath(), script));
        script = null;
        this.updateTime.set(FileUtil.getLastTime((String)this.fileName));
        this.packageId.set(pid);
    }
}

