/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.scripts.PageCacheChild;
import org.maachang.util.StringUtil;

public class PageCache {
    private static final Log LOG = LogFactory.getLog(PageCache.class);
    public static final String OUTPUT_METHOD = "$pageCache";
    private static final long DEFAULT_CACHE_TIME = 30L;
    private static final String CACHE_HEADER = "@cache@";
    private static final PageCache SNGL = new PageCache();
    private final Map<String, PageCacheChild> manager = new ConcurrentHashMap<String, PageCacheChild>();

    private PageCache() {
    }

    public static final PageCache getInstance() {
        return SNGL;
    }

    public void set(String url, long time, String cache) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0 || time <= 0L && cache == null || cache.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (url.endsWith("/index.mhtml")) {
            url = url.substring(0, url.length() - "index.mhtml".length());
        }
        if (time <= 0L) {
            time = 30L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("## \u6307\u5b9aURL[" + url + "]\u3092" + time + "\u79d2\u9593\u30da\u30fc\u30b8\u30ad\u30e3\u30c3\u30b7\u30e5\u3057\u307e\u3057\u305f"));
        }
        PageCacheChild ch = new PageCacheChild(System.currentTimeMillis() + time * 1000L, cache);
        this.manager.put(url, ch);
    }

    public String get(String url) throws Exception {
        PageCacheChild ch;
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (url.endsWith("/index")) {
            url = url.substring(0, url.length() - "index".length());
        }
        if ((ch = this.manager.get(url)) != null) {
            if (System.currentTimeMillis() >= ch.getLostTime()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("## \u6307\u5b9aURL[" + url + "]\u306e\u30da\u30fc\u30b8\u30ad\u30e3\u30c3\u30b7\u30e5\u3092\u7834\u68c4\u3057\u307e\u3057\u305f"));
                }
                this.manager.remove(url);
            } else {
                return ch.getCache();
            }
        }
        return null;
    }

    protected long analysisCacheMode(String[] data) throws Exception {
        if (data == null || data.length <= 0 || data[0].length() <= 0) {
            return -1L;
        }
        int p = data[0].toLowerCase().indexOf(CACHE_HEADER);
        if (p <= -1) {
            return -1L;
        }
        int end = data[0].indexOf("\n");
        if (end <= -1 && (end = data[0].indexOf("\r")) <= -1) {
            return -1L;
        }
        if (end < p) {
            return -1L;
        }
        String x = data[0].substring(0, end);
        data[0] = data[0].substring(end);
        int eq = x.indexOf("=", p);
        if (eq <= -1) {
            return 30L;
        }
        long ret = 30L;
        try {
            ret = Long.parseLong(StringUtil.trim((String)x.substring(eq, end)));
        }
        catch (Exception e) {
            ret = 30L;
        }
        if (ret <= -1L) {
            ret = 30L;
        }
        return ret;
    }
}

