/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.InputStream;

public class RequestBuffer {
    private static final int BUFFER = 8192;
    private byte[] binary = null;
    private int length = 0;
    private static final int TEMP_BINARY = 1024;
    private final byte[] tempBinary = new byte[1024];
    private int tempPos = 0;
    private int tempLen = 0;

    public RequestBuffer() {
        this.binary = new byte[8192];
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    protected void destroy() {
        this.binary = null;
        this.length = 0;
    }

    public void reset() {
        if (this.binary.length == 8192) {
            this.length = 0;
        } else {
            this.binary = new byte[8192];
            this.length = 0;
        }
    }

    public void clearTemp() {
        this.tempPos = 0;
        this.tempLen = 0;
    }

    public void write(int b) {
        this.addLimit(1);
        this.binary[this.length] = (byte)(b & 0xFF);
        ++this.length;
    }

    public void write(byte[] bin) {
        this.write(bin, -1);
    }

    public void write(byte[] bin, int len) {
        if (bin == null || bin.length <= 0) {
            return;
        }
        if (len <= 0 || bin.length <= len) {
            len = bin.length;
        }
        this.addLimit(len);
        System.arraycopy(bin, 0, this.binary, this.length, len);
        this.length += len;
    }

    public byte[] getRawBinary() {
        return this.binary;
    }

    public byte[] getBinary(int length) {
        if (length <= 0) {
            length = this.length;
        }
        if (this.length < length) {
            length = this.length;
        }
        byte[] ret = new byte[length];
        System.arraycopy(this.binary, 0, ret, 0, length);
        return ret;
    }

    public int getLength() {
        return this.length;
    }

    public int readRequest(InputStream in) throws Exception {
        if (this.tempLen <= this.tempPos) {
            this.tempLen = in.read(this.tempBinary, 0, 1024);
            this.tempPos = 0;
        }
        int ret = this.tempBinary[this.tempPos] & 0xFF;
        ++this.tempPos;
        return ret;
    }

    public int tempLength() {
        return this.tempLen - this.tempPos;
    }

    private void addLimit(int len) {
        if (this.binary.length <= this.length + len) {
            byte[] t = this.binary;
            int iLen = (int)((double)t.length * 1.5) + len;
            this.binary = new byte[iLen];
            System.arraycopy(t, 0, this.binary, 0, t.length);
            byte[] byArray = null;
        }
    }
}

