/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.OutputStream;
import org.maachang.comet.conf.MimeConfig;
import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

public class NetWriteHttpd {
    private static final String CHARSET = "UTF8";
    private static final String ENTER = "\r\n";
    private String url = null;
    private OutputStream outputStream = null;
    private StringBuilder cacheHeader = null;
    private String contentLength = null;
    private boolean gzipFlag = false;
    private boolean notCacheFlag = false;
    private boolean closeFlag = true;
    private boolean keepAliveFlag = false;
    private boolean chunkedFlag = true;
    private String version = null;
    private int state = 200;
    private boolean useFlag = false;
    private boolean outputStreamFlag = false;

    public void create(ConnectionInfo connectinoInfo, String url, int state) throws Exception {
        this.create(connectinoInfo, url, state, null, false);
    }

    public void create(ConnectionInfo connectinoInfo, String url, int state, String version) throws Exception {
        this.create(connectinoInfo, url, state, version, false);
    }

    public void create(ConnectionInfo connectinoInfo, String url, int state, String version, boolean keepAliveFlag) throws Exception {
        if (connectinoInfo == null || !connectinoInfo.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u3067\u3059");
        }
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IOException("URL\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        if (version == null || (version = version.trim()).length() <= 0) {
            version = "1.1";
        }
        this.version = version;
        this.keepAliveFlag = keepAliveFlag;
        this.state = state;
        this.outputStream = connectinoInfo.getOutputStream();
        this.url = url;
        this.useFlag = true;
    }

    public void clear() {
        this.url = null;
        this.outputStream = null;
        this.cacheHeader = null;
        this.contentLength = null;
        this.gzipFlag = false;
        this.notCacheFlag = false;
        this.closeFlag = true;
        this.keepAliveFlag = false;
        this.chunkedFlag = true;
        this.version = null;
        this.state = 200;
        this.useFlag = false;
        this.outputStreamFlag = false;
    }

    public void close() {
        if (this.outputStreamFlag) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clear();
    }

    public void baseHeader() {
        this.outputHttp(this.version, this.state);
    }

    public void pushHeader(String key, String value) {
        this.outputHeader(key, value);
    }

    public void pushHeaders(HttpdHeaders header) {
        if (header == null) {
            return;
        }
        String[] key = header.getKeys();
        if (key != null && key.length > 0) {
            int len = key.length;
            int i = 0;
            while (i < len) {
                int lenJ = header.size(key[i]);
                int j = 0;
                while (j < lenJ) {
                    this.outputHeader(key[i], header.getHeader(key[i], j));
                    ++j;
                }
                ++i;
            }
        }
    }

    public void cacheOff() {
        this.notCacheFlag = true;
    }

    public void closeOn() {
        this.closeFlag = true;
    }

    public void closeOff() {
        this.closeFlag = false;
    }

    public void setGzip(boolean mode) {
        this.gzipFlag = mode;
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    public boolean isChunked() {
        return this.chunkedFlag;
    }

    public OutputStream getOutputStream() throws Exception {
        OutputStream ret = null;
        if (this.cacheHeader != null) {
            this.writeHeader();
            ret = this.outputStream;
            this.outputStreamFlag = true;
        } else {
            ret = this.outputStream;
            this.outputStreamFlag = true;
        }
        return ret;
    }

    public boolean isWriteHeader() {
        return this.cacheHeader != null;
    }

    public boolean isHeader(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return false;
        }
        return this.cacheHeader != null && this.cacheHeader.indexOf(String.valueOf(key) + ": ") != -1;
    }

    public boolean isContentLength() {
        return this.contentLength != null;
    }

    public boolean useObject() {
        return this.useFlag;
    }

    private void outputHttp(String version, int state) {
        this.cacheHeader = new StringBuilder();
        this.cacheHeader.append("HTTP/").append(version).append(" ").append(state).append(" ").append(HttpdErrorDef.convertErrorMessage(state)).append(" ").append(ENTER);
        this.outputHeader("Server", HttpdVersionDef.getPrintServerName());
        this.outputHeader("Date", HttpdTimestamp.getNowTimestamp());
        if (!"1.1".equals(version)) {
            this.outputHeader("Connection", "close");
        } else if (this.closeFlag) {
            this.outputHeader("Connection", "close");
        } else {
            this.outputHeader("Connection", "Keep-Alive");
        }
    }

    private void notCache() {
        if (this.cacheHeader != null && !this.isHeader("Expires") && !this.isHeader("Pragma")) {
            this.outputHeader("Expires", HttpdTimestamp.getTimestamp(0L));
            this.outputHeader("Pragma", "no-cache");
            if (!this.isHeader("Last-Modified")) {
                this.outputHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
            }
            this.outputHeader("Cache-Control", "private");
            this.outputHeader("Cache-Control", "no-cache");
            this.outputHeader("Cache-Control", "no-store");
            this.outputHeader("Cache-Control", "max-age=0");
        }
    }

    private void outputHeader(String key, String value) {
        if (key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        if (this.cacheHeader != null) {
            if (key.equals("Content-Length")) {
                this.contentLength = key + ": " + value;
            } else {
                this.cacheHeader.append(key).append(": ").append(value).append(ENTER);
            }
        }
    }

    private void writeHeader() throws Exception {
        try {
            if (this.cacheHeader != null) {
                if (!NetWriteHttpd.isContentType(this.cacheHeader)) {
                    if (this.state >= 400) {
                        this.cacheHeader.append("Content-Type").append(": ").append("text/html; charset=utf-8").append(ENTER);
                    } else {
                        NetWriteHttpd.noSetByContentType(this.cacheHeader, this.url);
                    }
                }
                if ("1.1".equals(this.version) && this.gzipFlag) {
                    this.chunkedFlag = true;
                    if (this.cacheHeader.indexOf("Transfer-Encoding:") == -1) {
                        this.cacheHeader.append("Transfer-Encoding: chunked").append(ENTER);
                    }
                } else {
                    if (this.keepAliveFlag) {
                        this.chunkedFlag = true;
                    }
                    if (this.contentLength != null) {
                        this.cacheHeader.append(this.contentLength).append(ENTER);
                        this.chunkedFlag = false;
                    }
                    if (!"1.1".equals(this.version)) {
                        this.keepAliveFlag = false;
                        this.chunkedFlag = false;
                    }
                    if (this.chunkedFlag && this.cacheHeader.indexOf("Transfer-Encoding:") == -1) {
                        this.cacheHeader.append("Transfer-Encoding: chunked").append(ENTER);
                    }
                }
                if (this.notCacheFlag) {
                    this.notCache();
                }
                this.cacheHeader.append(ENTER);
                String hd = this.cacheHeader.toString();
                this.cacheHeader = null;
                byte[] writeHd = hd.getBytes(CHARSET);
                hd = null;
                this.outputStream.write(writeHd, 0, writeHd.length);
                byte[] byArray = null;
            }
        }
        catch (Exception e) {
            if (this.outputStream != null) {
                try {
                    this.outputStream.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outputStream = null;
            }
            throw e;
        }
    }

    private static final void noSetByContentType(StringBuilder buf, String url) {
        if ((url = FileUtil.getFileName((String)url)).indexOf(".") == -1 && url.endsWith(".ms")) {
            buf.append("Content-Type").append(": ").append("text/xml; charset=utf-8").append(ENTER);
        } else if (url.endsWith(".mhtml")) {
            buf.append("Content-Type").append(": ").append("text/html; charset=utf-8").append(ENTER);
        } else {
            MimeConfig conf = (MimeConfig)GlobalManager.getValue((String)"MIME_TYPE");
            String mime = conf.getNameByMimeType(url);
            if (mime.indexOf("xml") != -1 || mime.indexOf("html") != -1) {
                buf.append("Content-Type").append(": ").append(mime).append("; charset=utf-8").append(ENTER);
            } else {
                buf.append("Content-Type").append(": ").append(mime).append(ENTER);
            }
        }
    }

    private static final boolean isContentType(StringBuilder buf) {
        return buf.indexOf("Content-Type: ") != -1;
    }
}

