/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;

class NioInputStream
extends InputStream {
    private static final long TIMEOUT = 5000L;
    private static final long MIN_TIMEOUT = 500L;
    private ReceiveBuffer recvBuffer = null;
    private long timeout = -1L;

    public InputStream create(NioElement element) throws Exception {
        return this.create(element, 5000L);
    }

    public InputStream create(NioElement element, long timeout) throws Exception {
        if (element == null || !element.isUse()) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.close();
        this.recvBuffer = element.getReceiveBuffer();
        this.timeout = timeout <= 500L ? 500L : timeout;
        return this;
    }

    protected void finalize() throws Exception {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.recvBuffer != null) {
            this.recvBuffer.reset();
        }
        this.recvBuffer = null;
    }

    public int available() throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.recvBuffer.length();
    }

    public int read() throws IOException {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        return this.recvBuffer.get(this.timeout);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("\u7bc4\u56f2\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
        }
        if (len == 0) {
            return 0;
        }
        return this.recvBuffer.get(this.timeout, b, off, len);
    }

    public boolean markSupported() {
        return false;
    }

    private boolean isUse() {
        return this.recvBuffer != null && this.recvBuffer.isUse();
    }
}

