/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioReceiveServer;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.atomic.AtomicINT;

class NioReceiveServerArray {
    private static final int MIN_SIZE = 1;
    private NioReceiveServer[] recvs = null;
    private int size = 0;
    private final AtomicINT seq = new AtomicINT(0);

    private NioReceiveServerArray() {
    }

    public NioReceiveServerArray(ReceiveLinkQueue queue, int size) throws Exception {
        if (queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (size <= 1) {
            size = 1;
        }
        NioReceiveServer[] rv = new NioReceiveServer[size];
        int i = 0;
        while (i < size) {
            rv[i] = new NioReceiveServer(queue);
            ++i;
        }
        this.recvs = rv;
        this.size = size;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        int len = this.recvs.length;
        int i = 0;
        while (i < len) {
            if (this.recvs[i] != null) {
                this.recvs[i].destroy();
            }
            ++i;
        }
    }

    public void setElement(NioElement element) throws Exception {
        if (element == null) {
            return;
        }
        int no = this.seq.get();
        if (no >= this.size) {
            no = 0;
            this.seq.set(0);
        } else {
            this.seq.inc();
        }
        this.recvs[no].setElement(element);
    }
}

