/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.NioSslUtil;
import org.maachang.comet.net.nio.NioTcpUtil;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioSslReceiveServer
extends LoopThread {
    private Selector selector = null;
    private IsReadQueue isRecvQueue = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;
    private final ByteBuffer sendBuffer = ByteBuffer.allocateDirect(1024);

    private NioSslReceiveServer() {
    }

    public NioSslReceiveServer(ReceiveLinkQueue executionQueue) throws Exception {
        if (executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.selector = Selector.open();
        this.isRecvQueue = new IsReadQueue();
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        super.setPriority(6);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    public void setElement(NioElement element) throws Exception {
        element.setIsWriteQueue(this.isWriteQueue);
        this.isRecvQueue.append(element);
        this.selector.wakeup();
    }

    protected void clear() {
        try {
            Iterator<SelectionKey> itr = this.selector.keys().iterator();
            while (itr.hasNext()) {
                try {
                    NioTcpUtil.destroyKey(itr.next());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.selector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean execution() throws Exception {
        wakeupFlag = false;
        counter = 0;
        block0: while (true) {
            if (NioTcpUtil.isSendOrWrite(this.selector, this.isRecvQueue, this.isWriteQueue)) {
                wakeupFlag = true;
            }
            if (wakeupFlag) {
                wakeupFlag = false;
                counter = this.selector.selectNow();
            } else {
                wakeupFlag = false;
                counter = this.selector.select();
            }
            if (counter <= 0) continue;
            itr = this.selector.selectedKeys().iterator();
            while (true) {
                if (itr.hasNext()) ** break;
                continue block0;
                if (NioTcpUtil.isSendOrWrite(this.selector, this.isRecvQueue, this.isWriteQueue)) {
                    wakeupFlag = true;
                }
                key = itr.next();
                itr.remove();
                if (key == null) continue;
                if (!key.isValid()) {
                    NioTcpUtil.destroyKey(key);
                    continue;
                }
                NioSslUtil.isRead(this.selector, key, this.executionQueue);
                NioSslUtil.isWrite(this.selector, key, this.executionQueue, this.sendBuffer);
            }
            break;
        }
    }

    protected void toException(Throwable e) {
    }
}

