/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveBuffer;
import org.maachang.comet.net.ssl.CloseSslException;
import org.maachang.comet.net.ssl.SslUtil;
import org.maachang.util.atomic.AtomicBOOL;
import org.maachang.util.atomic.AtomicOBJECT;

public class SslElement {
    private final AtomicOBJECT<NioElement> element = new AtomicOBJECT();
    private final AtomicOBJECT<SSLEngine> sslEngine = new AtomicOBJECT();
    private final AtomicOBJECT<ByteBuffer> netInBuffer = new AtomicOBJECT();
    private final AtomicOBJECT<ByteBuffer> netOutBuffer = new AtomicOBJECT();
    private final AtomicOBJECT<ByteBuffer> recvBuffer = new AtomicOBJECT();
    private final AtomicOBJECT<SSLEngineResult.HandshakeStatus> handShakeState = new AtomicOBJECT();
    private final AtomicBOOL isHandShakeFinish = new AtomicBOOL(false);
    private final AtomicBOOL isClose = new AtomicBOOL(false);
    private final AtomicBOOL isExitHandShakeSend = new AtomicBOOL(false);
    private int recvBufferSize = -1;
    private int defaultSize = -1;

    private SslElement() {
    }

    public SslElement(NioElement element, SSLEngine engine) throws Exception {
        if (element == null || engine == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.recvBufferSize = engine.getSession().getApplicationBufferSize();
        this.defaultSize = engine.getSession().getPacketBufferSize() * 2;
        this.recvBuffer.set((Object)ByteBuffer.allocate(this.recvBufferSize));
        this.netInBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
        this.netOutBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
        ((ByteBuffer)this.netOutBuffer.get()).limit(0);
        this.sslEngine.set((Object)engine);
        this.element.set((Object)element);
        this.isHandShakeFinish.set(false);
        this.isExitHandShakeSend.set(false);
        this.isClose.set(false);
        engine.beginHandshake();
        String[] supportCiphers = engine.getSupportedCipherSuites();
        if (supportCiphers != null) {
            engine.setEnabledCipherSuites(supportCiphers);
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.sslEngine.get() != null) {
            try {
                ((SSLEngine)this.sslEngine.get()).closeInbound();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ((SSLEngine)this.sslEngine.get()).closeOutbound();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sslEngine.set(null);
        this.netInBuffer.set(null);
        this.netOutBuffer.set(null);
        this.element.set(null);
        this.recvBuffer.set(null);
        this.isClose.set(true);
    }

    public void close() throws Exception {
        if (this.element.get() != null && this.sslEngine.get() != null) {
            ((NioElement)this.element.get()).restartWrite();
            ((SSLEngine)this.sslEngine.get()).closeInbound();
            ((SSLEngine)this.sslEngine.get()).closeOutbound();
            SSLEngineResult res = SslUtil.wrap((SSLEngine)this.sslEngine.get(), SslUtil.EMPTY_BUFFER, (ByteBuffer)this.netOutBuffer.get());
            if (res.getStatus() == SSLEngineResult.Status.CLOSED) {
                this.writeQueue((ByteBuffer)this.netOutBuffer.get());
            }
        }
    }

    public void clearBuffer() {
        if (this.element.get() != null) {
            this.recvBuffer.set((Object)ByteBuffer.allocate(this.recvBufferSize));
            this.netInBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
            this.netOutBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
            ((ByteBuffer)this.netOutBuffer.get()).limit(0);
        } else {
            this.recvBuffer.set(null);
            this.netInBuffer.set(null);
            this.netOutBuffer.set(null);
        }
    }

    public boolean isClosed() {
        return this.isClose.get();
    }

    public boolean isHandShake() {
        return this.isHandShakeFinish.get();
    }

    public void sendEndHandShake() {
        if (this.isHandShakeFinish.get()) {
            this.isExitHandShakeSend.set(true);
            this.netInBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
            this.netOutBuffer.set((Object)ByteBuffer.allocate(this.defaultSize));
            ((ByteBuffer)this.netOutBuffer.get()).limit(0);
        }
    }

    public boolean isSendEndHandShake() {
        return this.isExitHandShakeSend.get();
    }

    public ByteBuffer getRecvBuffer() {
        return (ByteBuffer)this.recvBuffer.get();
    }

    public void handShake(ByteBuffer recvBuf) throws Exception {
        if (this.isClose.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (this.handShakeState.get() == null) {
            ((SSLEngine)this.sslEngine.get()).beginHandshake();
            this.handShakeState.set((Object)((SSLEngine)this.sslEngine.get()).getHandshakeStatus());
        }
        SSLEngineResult result = null;
        if (this.isUseReadData(recvBuf)) {
            if (this.isHandShakeFinish.get()) {
                throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u306f\u5b8c\u4e86\u3057\u3066\u3044\u307e\u3059");
            }
            result = SslUtil.unwrap((SSLEngine)this.sslEngine.get(), recvBuf, (ByteBuffer)this.netInBuffer.get());
            this.handShakeState.set((Object)result.getHandshakeStatus());
            while (result.getStatus() != SSLEngineResult.Status.OK) {
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    this.netInBuffer.set((Object)SslUtil.reallocate((ByteBuffer)this.netInBuffer.get()));
                    result = SslUtil.unwrap((SSLEngine)this.sslEngine.get(), recvBuf, (ByteBuffer)this.netInBuffer.get());
                    this.handShakeState.set((Object)result.getHandshakeStatus());
                    continue;
                }
                throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + this.handShakeState.get() + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
            }
        } else {
            return;
        }
        boolean roopEnd = true;
        block7: while (roopEnd) {
            switch ((SSLEngineResult.HandshakeStatus)((Object)this.handShakeState.get())) {
                case NEED_WRAP: {
                    result = SslUtil.wrap((SSLEngine)this.sslEngine.get(), SslUtil.EMPTY_BUFFER, (ByteBuffer)this.netOutBuffer.get());
                    this.handShakeState.set((Object)result.getHandshakeStatus());
                    if (result.getStatus() == SSLEngineResult.Status.OK) {
                        this.writeQueue((ByteBuffer)this.netOutBuffer.get());
                        if (this.handShakeState.get() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP) continue block7;
                        roopEnd = false;
                        break;
                    }
                    throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + this.handShakeState.get() + "/" + (Object)((Object)result.getStatus()) + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                }
                case NEED_UNWRAP: {
                    if (this.isUseReadData(recvBuf)) {
                        while (true) {
                            result = SslUtil.unwrap((SSLEngine)this.sslEngine.get(), recvBuf, (ByteBuffer)this.netInBuffer.get());
                            this.handShakeState.set((Object)result.getHandshakeStatus());
                            if (result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) continue block7;
                            this.netInBuffer.set((Object)SslUtil.reallocate((ByteBuffer)this.netInBuffer.get()));
                        }
                    }
                    if (this.handShakeState.get() != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this.isUseReadData(recvBuf)) continue block7;
                    roopEnd = false;
                    break;
                }
                case NEED_TASK: {
                    this.handShakeState.set((Object)this.tasks());
                    break;
                }
                case FINISHED: {
                    this.isHandShakeFinish.set(true);
                    roopEnd = false;
                    break;
                }
                default: {
                    throw new IOException("\u4e0d\u660e\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + this.handShakeState.get() + "]\u304c\u8fd4\u3055\u308c\u307e\u3057\u305f");
                }
            }
        }
    }

    public boolean isUseReadData(ByteBuffer recvBuf) {
        boolean ret;
        boolean bl = ret = recvBuf.position() != 0 && recvBuf.hasRemaining() && this.handShakeState.get() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        if (!ret) {
            ret = recvBuf.position() == recvBuf.capacity();
        }
        return ret;
    }

    public boolean read(ByteBuffer recvBuf) throws Exception {
        this.checkExitHandShake();
        boolean ret = false;
        int len = ((NioElement)this.element.get()).getChannel().read(recvBuf);
        if (len <= 0) {
            try {
                ((SSLEngine)this.sslEngine.get()).closeInbound();
            }
            catch (IOException iOException) {}
        } else {
            this.readToSslConvert(((NioElement)this.element.get()).getReceiveBuffer(), recvBuf);
            ((NioElement)this.element.get()).update();
            ret = true;
        }
        return ret;
    }

    public boolean readTo(ByteBuffer recvBuf) throws Exception {
        boolean ret = false;
        if (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
            while (recvBuf.position() != 0 && recvBuf.hasRemaining()) {
                int ln = this.readToSslConvert(((NioElement)this.element.get()).getReceiveBuffer(), recvBuf);
                ret = true;
                if (ln <= 0) break;
            }
        }
        return ret;
    }

    public void write(ByteBuffer buf) throws Exception {
        this.checkExitHandShake();
        int written = 0;
        SSLEngineResult result = SslUtil.wrap((SSLEngine)this.sslEngine.get(), buf, (ByteBuffer)this.netOutBuffer.get());
        written = result.bytesConsumed();
        if (result.getStatus() == SSLEngineResult.Status.OK) {
            if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                throw new CloseSslException("SSL\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30af\u30ed\u30fc\u30ba");
            }
            throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)result.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        }
        ((NioElement)this.element.get()).getChannel().write((ByteBuffer)this.netOutBuffer.get());
        if (buf.limit() != written) {
            buf.position(written);
            buf.compact();
            ((NioElement)this.element.get()).getSendBuffer().writeHead(buf);
        }
    }

    private void checkExitHandShake() throws Exception {
        if (this.isClose.get()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        if (!this.isExitHandShakeSend.get()) {
            throw new IOException("\u30cf\u30f3\u30c9\u30b7\u30a7\u30a4\u30af\u51e6\u7406\u304c\u7d42\u4e86\u3057\u3066\u3044\u307e\u305b\u3093");
        }
    }

    private SSLEngineResult.HandshakeStatus tasks() {
        Runnable r = null;
        while ((r = ((SSLEngine)this.sslEngine.get()).getDelegatedTask()) != null) {
            r.run();
        }
        return ((SSLEngine)this.sslEngine.get()).getHandshakeStatus();
    }

    private void writeQueue(ByteBuffer buf) throws Exception {
        if (this.element.get() != null && ((NioElement)this.element.get()).isUse()) {
            ((NioElement)this.element.get()).getSendBuffer().write((ByteBuffer)this.netOutBuffer.get());
        }
    }

    private int readToSslConvert(ReceiveBuffer emtBuf, ByteBuffer recvBuf) throws Exception {
        ((ByteBuffer)this.netInBuffer.get()).clear();
        int recv = 0;
        do {
            SSLEngineResult unwrap;
            if ((unwrap = SslUtil.unwrap((SSLEngine)this.sslEngine.get(), recvBuf, (ByteBuffer)this.netInBuffer.get())).getStatus() == SSLEngineResult.Status.OK || unwrap.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                recv += unwrap.bytesProduced();
                if (unwrap.getStatus() == SSLEngineResult.Status.OK) {
                    ((ByteBuffer)this.netInBuffer.get()).flip();
                    emtBuf.put((ByteBuffer)this.netInBuffer.get());
                    ((ByteBuffer)this.netInBuffer.get()).clear();
                }
                if (unwrap.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (unwrap.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (unwrap.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && recv > 0 || unwrap.getStatus() == SSLEngineResult.Status.CLOSED || unwrap.getStatus() == SSLEngineResult.Status.CLOSED) break;
            throw new IOException("\u4e0d\u6b63\u306a\u30b9\u30c6\u30fc\u30bf\u30b9[" + (Object)((Object)unwrap.getStatus()) + "]\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
        } while (recv != 0);
        return recv;
    }
}

