/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.local;

import org.maachang.session.client.PSession;
import org.maachang.session.client.PSessionManager;
import org.maachang.session.client.local.PSessionLocalImpl;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.util.BaseRandom;

class PSessionLocalManagerImpl
implements PSessionManager {
    private PersistenceEngine engine = null;
    private long deleteTime = -1L;

    private PSessionLocalManagerImpl() {
    }

    public PSessionLocalManagerImpl(PersistenceEngine engine) throws Exception {
        if (engine == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.engine = engine;
    }

    public String createSession(BaseRandom baseRandom) throws Exception {
        return this.engine.createSessionId(baseRandom);
    }

    public PSession getSession(BaseRandom baseRandom) throws Exception {
        return this.getSession(baseRandom, null);
    }

    public PSession getSession(BaseRandom baseRandom, String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            sessionId = this.engine.createSessionId(baseRandom);
        }
        if (!this.engine.containsKey(sessionId)) {
            sessionId = this.engine.createSessionId(baseRandom);
        }
        return new PSessionLocalImpl(sessionId, this.engine);
    }

    public void reomveSession(String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30bb\u30c3\u30b7\u30e7\u30f3ID\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.engine.remove(sessionId);
    }

    public boolean isSession(String sessionId) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        return this.engine.containsKey(sessionId);
    }

    public long getDeleteSessionTime() throws Exception {
        if (this.deleteTime > 0L) {
            return this.deleteTime;
        }
        this.deleteTime = this.engine.getDeleteSessionTime();
        return this.deleteTime;
    }
}

