/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.io.IOException;
import org.maachang.dbm.MDbmIO;
import org.maachang.dbm.MDbmOp;
import org.maachang.session.engine.CreateSession;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.engine.SessionCache;
import org.maachang.util.BaseRandom;

class PersistenceEngineImpl
implements PersistenceEngine {
    private static final int WAIT_LOOP = 25;
    private static final int WAIT_TIME = 100;
    private SessionCache sessionCache = null;
    private CreateSession createSession = null;

    private PersistenceEngineImpl() {
    }

    public PersistenceEngineImpl(MDbmOp mdbm, int cacheTimeout, int sessionTimeout) throws Exception {
        if (mdbm == null || !mdbm.isUse() || !(mdbm.maachangDbm() instanceof MDbmIO)) {
            if (mdbm == null || !mdbm.isUse()) {
                throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fMDbm\u306f\u4e0d\u6b63\u3067\u3059");
            }
            throw new IllegalArgumentException("MDbm\u306fRemote\u53ca\u3073Transaction\u3067\u306f\u6271\u3048\u307e\u305b\u3093");
        }
        SessionCache sessionCache = new SessionCache(mdbm, cacheTimeout, sessionTimeout);
        if (!sessionCache.isUse()) {
            boolean flg = false;
            int i = 0;
            while (i < 25) {
                if (sessionCache.isUse()) {
                    flg = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            if (!flg) {
                throw new IOException("\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
        CreateSession createSession = new CreateSession(sessionCache);
        this.sessionCache = sessionCache;
        this.createSession = createSession;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.createSession != null) {
            this.createSession.destroy();
        }
        this.createSession = null;
        if (this.sessionCache != null) {
            this.sessionCache.destroy();
        }
        this.sessionCache = null;
    }

    public String createSessionId(BaseRandom baseRandom) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        return this.createSession.createSessionKey(baseRandom);
    }

    public void put(String sessionId, String key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        this.sessionCache.put(sessionId, key, value);
    }

    public void remove(String sessionId) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        this.sessionCache.remove(sessionId);
    }

    public void remove(String sessionId, String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        this.sessionCache.remove(sessionId, key);
    }

    public byte[] get(String sessionId, String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        return this.sessionCache.get(sessionId, key);
    }

    public long getLastUpdateTime(String sessionId) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        return this.sessionCache.getLastUpdateTime(sessionId);
    }

    public boolean containsKey(String sessionId) {
        if (!this.isUse()) {
            return false;
        }
        boolean ret = false;
        ret = this.sessionCache.containsKey(sessionId);
        if (!ret) {
            return this.createSession.containsKey(sessionId);
        }
        return ret;
    }

    public MDbmOp getMDbm() {
        return this.isUse() ? this.sessionCache.getMDbm() : null;
    }

    public long getDeleteSessionTime() {
        if (!this.isUse()) {
            return -1L;
        }
        return this.sessionCache.getDeleteSessionTime();
    }

    public boolean isUse() {
        return this.sessionCache != null && this.createSession != null && this.createSession.isUse();
    }
}

