/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.conf.Config;
import org.maachang.conf.ReadConfigUtil;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmIO;
import org.maachang.dbm.MDbmManager;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.engine.PersistenceEngineImpl;

public class PersistenceService {
    private static final Log LOG = LogFactory.getLog(PersistenceService.class);
    private static final String MDBM_CONF = "./conf/mdbm.conf";
    private static final String SESSION_CONF = "./conf/session.conf";
    private static final PersistenceService SNGL = new PersistenceService();
    private PersistenceEngineImpl engine = null;

    private PersistenceService() {
    }

    public static final PersistenceService getInstance() {
        return SNGL;
    }

    public synchronized void init() throws Exception {
        if (this.engine == null) {
            Config conf = new Config();
            if (!ReadConfigUtil.readConfig((Config)conf, (String)MDBM_CONF) || !conf.isSection("mdbm")) {
                throw new IOException("mdbm.conf\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
            MDbmManager.getInstance().open(conf.get("mdbm", "directory", 0));
            conf = null;
            MDbm mdbm = MDbmManager.getInstance().getMDbm();
            this.init(mdbm);
        }
    }

    public synchronized void init(MDbm mdbm) throws Exception {
        if (this.engine == null) {
            LOG.info((Object)"## PersistenceService - \u751f\u6210.");
            if (mdbm == null || !mdbm.isUse()) {
                throw new IllegalArgumentException("\u6307\u5b9aMDBM\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (!(mdbm instanceof MDbmIO)) {
                throw new IllegalArgumentException("MDbm\u306fRemote\u53ca\u3073Transaction\u3067\u306f\u6271\u3048\u307e\u305b\u3093");
            }
            try {
                Config conf = new Config();
                this.engine = !ReadConfigUtil.readConfig((Config)conf, (String)SESSION_CONF) || !conf.isSection("session") ? new PersistenceEngineImpl(MDbmManager.getInstance().getMDbmOp(mdbm), -1, -1) : new PersistenceEngineImpl(MDbmManager.getInstance().getMDbmOp(mdbm), conf.getInt("session", "cacheTime", 0), conf.getInt("session", "sessionTime", 0));
            }
            catch (Exception e) {
                this.engine = null;
                throw e;
            }
        }
    }

    public synchronized void destroy() {
        if (this.engine != null) {
            LOG.info((Object)"## PersistenceService - \u7834\u68c4.");
            try {
                this.engine.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.engine = null;
    }

    public synchronized PersistenceEngine getEngine() {
        return this.engine;
    }
}

