/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.dbm.MDbmIO;
import org.maachang.dbm.MDbmOp;
import org.maachang.session.engine.CacheSessionMonThread;
import org.maachang.session.engine.CacheValue;
import org.maachang.session.engine.MDbmSessionMonThread;
import org.maachang.session.engine.SessionChild;
import org.maachang.session.engine.SessionIdLock;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionCache {
    protected static final String BASE_SESSION_KEY = "@session@base:";
    protected static final String VALUE_SESSION_KEY = "@session@value:";
    private static final long DEFAULT_DELETE_CACHE = 300000L;
    private static final long MIN_DELETE_CACHE = 60000L;
    private static final long MAX_DELETE_CACHE = 1800000L;
    private static final long DEFAULT_DELETE_SESSION = 86400000L;
    private static final long MIN_DELETE_SESSION = 1800000L;
    private static final long MAX_DELETE_SESSION = 604800000L;
    private MDbmOp mdbm = null;
    private Map<String, CacheValue> cache = null;
    private long cacheTimeout = -1L;
    private long sessionTimeout = -1L;
    private CacheSessionMonThread cacheThread = null;
    private MDbmSessionMonThread sessionThread = null;
    private final SessionIdLock idLock = new SessionIdLock();

    private SessionCache() {
    }

    public SessionCache(MDbmOp mdbm, long cacheTimeout, long sessionTimeout) throws Exception {
        if (mdbm == null || !mdbm.isUse()) {
            throw new IllegalArgumentException("\u7121\u52b9\u306aMDBM\u3092\u8a2d\u5b9a\u3057\u3066\u3044\u307e\u3059");
        }
        if (cacheTimeout <= -1L) {
            cacheTimeout = 300000L;
        } else if (cacheTimeout <= 60000L) {
            cacheTimeout = 60000L;
        } else if (cacheTimeout >= 1800000L) {
            cacheTimeout = 1800000L;
        }
        if (sessionTimeout <= -1L) {
            sessionTimeout = 86400000L;
        } else if (sessionTimeout <= 1800000L) {
            sessionTimeout = 1800000L;
        } else if (sessionTimeout >= 604800000L) {
            sessionTimeout = 604800000L;
        }
        this.mdbm = mdbm;
        this.cacheTimeout = cacheTimeout;
        this.sessionTimeout = sessionTimeout;
        this.cache = new ConcurrentHashMap<String, CacheValue>();
        this.cacheThread = new CacheSessionMonThread(this.cache, this.idLock, this.cacheTimeout);
        this.sessionThread = new MDbmSessionMonThread(this.mdbm, this.cache, this.idLock, this.sessionTimeout);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.sessionThread != null) {
            this.sessionThread.stopThread();
        }
        this.sessionThread = null;
        if (this.cacheThread != null) {
            this.cacheThread.stopThread();
        }
        this.cacheThread = null;
        if (this.mdbm != null) {
            try {
                this.mdbm.maachangDbm().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mdbm = null;
        if (this.cache != null) {
            this.cache.clear();
        }
        this.cache = null;
        this.cacheTimeout = -1L;
        this.sessionTimeout = -1L;
    }

    public void put(String sessionId, String key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48 || key == null || (key = key.trim()).length() <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        sessionId = SessionCache.toSessionId(sessionId);
        this.idLock.lock(sessionId);
        try {
            String skey = SessionCache.convertSessionKey(sessionId);
            String vKey = SessionCache.convertSessionValueKey(sessionId, key);
            if (!this.mdbm.containsKey(skey)) {
                SessionChild ch = new SessionChild();
                ch.getChild().add(key.getBytes("UTF8"));
                byte[] b = ch.toBinary();
                ch = null;
                this.mdbm.put(skey, b);
                this.mdbm.put(vKey, value);
            } else {
                this.cache.remove(sessionId);
                byte[] b = this.mdbm.get(skey);
                SessionChild ch = new SessionChild(b);
                b = null;
                if (!ch.containsKey(key)) {
                    ch.update();
                    ch.getChild().add(key.getBytes("UTF8"));
                    b = ch.toBinary();
                    this.mdbm.put(skey, b);
                    b = null;
                } else {
                    SessionCache.setSessionTime(this.mdbm, sessionId);
                }
                this.mdbm.put(vKey, value);
            }
        }
        finally {
            this.idLock.unlock(sessionId);
        }
    }

    public void remove(String sessionId) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        sessionId = SessionCache.toSessionId(sessionId);
        this.idLock.lock(sessionId);
        try {
            if (this.mdbm.containsKey(SessionCache.convertSessionKey(sessionId))) {
                SessionCache.removeSession(this.mdbm, this.cache, sessionId);
            }
        }
        finally {
            this.idLock.unlock(sessionId);
        }
    }

    public void remove(String sessionId, String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48 || key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        sessionId = SessionCache.toSessionId(sessionId);
        this.idLock.lock(sessionId);
        try {
            String vKey = SessionCache.convertSessionValueKey(sessionId, key);
            if (this.mdbm.containsKey(vKey)) {
                this.cache.remove(sessionId);
                SessionCache.setSessionTime(this.mdbm, sessionId);
                this.mdbm.remove(vKey);
            }
        }
        finally {
            this.idLock.unlock(sessionId);
        }
    }

    public byte[] get(String sessionId, String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48 || key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        sessionId = SessionCache.toSessionId(sessionId);
        byte[] ret = null;
        this.idLock.lock(sessionId);
        try {
            String vKey;
            CacheValue cacheVal;
            int no;
            boolean cacheSessionFlag = this.cache.containsKey(sessionId);
            if (cacheSessionFlag && (no = (cacheVal = this.cache.get(sessionId)).search(key)) >= 0) {
                SessionCache.setSessionTime(this.mdbm, sessionId);
                ret = cacheVal.get(no);
            }
            if (ret == null && this.mdbm.containsKey(vKey = SessionCache.convertSessionValueKey(sessionId, key))) {
                SessionCache.setSessionTime(this.mdbm, sessionId);
                ret = this.mdbm.get(vKey);
                if (ret != null) {
                    CacheValue cacheVal2 = null;
                    if (!cacheSessionFlag) {
                        cacheVal2 = new CacheValue();
                        this.cache.put(sessionId, cacheVal2);
                    } else {
                        cacheVal2 = this.cache.get(sessionId);
                    }
                    cacheVal2.put(key, ret);
                }
            }
        }
        finally {
            this.idLock.unlock(sessionId);
        }
        return ret;
    }

    public long getLastUpdateTime(String sessionId) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        long ret = -1L;
        sessionId = SessionCache.toSessionId(sessionId);
        this.idLock.lock(sessionId);
        try {
            ret = SessionCache.getSessionTime(this.mdbm, sessionId);
        }
        finally {
            this.idLock.unlock(sessionId);
        }
        return ret;
    }

    public boolean containsKey(String sessionId) {
        if (!this.isUse()) {
            return false;
        }
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        sessionId = SessionCache.toSessionId(sessionId);
        boolean ret = false;
        try {
            this.idLock.lock(sessionId);
            try {
                ret = this.mdbm.containsKey(SessionCache.convertSessionKey(sessionId));
            }
            finally {
                this.idLock.unlock(sessionId);
            }
            return ret;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public MDbmOp getMDbm() {
        return this.isUse() ? this.mdbm : null;
    }

    public long getDeleteSessionTime() {
        return this.sessionTimeout;
    }

    public boolean isUse() {
        return this.mdbm != null && this.mdbm.isUse() && this.cache != null && this.cacheThread != null && !this.cacheThread.isStop() && this.sessionThread != null && !this.sessionThread.isStop();
    }

    protected static final long getSessionTime(MDbmOp op, String key) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0) {
            return -1L;
        }
        if (!key.startsWith(BASE_SESSION_KEY)) {
            key = SessionCache.convertSessionKey(key);
        }
        MDbmIO io = (MDbmIO)op.maachangDbm();
        byte[] b = new byte[8];
        io.read(key.getBytes("UTF8"), b, 0, 0, 8);
        return ConvertParam.convertLong((int)0, (byte[])b);
    }

    protected static final void setSessionTime(MDbmOp op, String key) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        if (!key.startsWith(BASE_SESSION_KEY)) {
            key = SessionCache.convertSessionKey(key);
        }
        MDbmIO io = (MDbmIO)op.maachangDbm();
        byte[] b = ConvertParam.convertLong((long)System.currentTimeMillis());
        io.write(key.getBytes("UTF8"), b, 0, 0, 8);
    }

    protected static final void removeSession(MDbmOp op, Map<String, CacheValue> cache, String key) throws Exception {
        String baseKey;
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        if (key.startsWith(BASE_SESSION_KEY)) {
            key = SessionCache.toSessionId(key);
        }
        if (cache.containsKey(key)) {
            cache.remove(key);
        }
        if (op.containsKey(baseKey = SessionCache.convertSessionKey(key))) {
            byte[] b = op.get(baseKey);
            SessionChild ch = new SessionChild(b);
            b = null;
            ArrayList<byte[]> lst = ch.getChild();
            int len = lst.size();
            int i = 0;
            while (i < len) {
                String valKey = SessionCache.convertSessionValueKey(key, new String(lst.get(i), "UTF8"));
                if (op.containsKey(valKey)) {
                    op.remove(valKey);
                }
                ++i;
            }
            op.remove(baseKey);
        }
    }

    protected static final String convertSessionKey(String name) {
        return BASE_SESSION_KEY + name;
    }

    protected static final String toSessionId(String name) {
        if (name.startsWith(BASE_SESSION_KEY)) {
            return name.substring(BASE_SESSION_KEY.length());
        }
        return name;
    }

    protected static final String convertSessionValueKey(String sessionId, String key) {
        return VALUE_SESSION_KEY + sessionId + "." + key;
    }
}

