/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio;

import java.io.IOException;
import org.maachang.rawio.Baseio;
import org.maachang.rawio.DirectIOImpl;
import org.maachang.rawio.EmulationRawIOImpl;
import org.maachang.rawio.NativeRawIO;
import org.maachang.rawio.mapping.MappingioInstance;

public abstract class RawioInstance {
    private RawioInstance() {
    }

    public static final Baseio open(String name) throws Exception {
        return RawioInstance.open(false, name);
    }

    public static final Baseio open(boolean mode, String name) throws Exception {
        Baseio ret = !NativeRawIO.useInit() ? new EmulationRawIOImpl(name) : new DirectIOImpl(name);
        if (mode) {
            ret = MappingioInstance.getInstance(ret);
        }
        return ret;
    }

    public static final Baseio openDirect(String name) throws Exception {
        return RawioInstance.openDirect(false, name);
    }

    public static final Baseio openDirect(boolean mode, String name) throws Exception {
        if (!NativeRawIO.useInit()) {
            throw new IOException("DirectI/O\u306e\u751f\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        Baseio ret = new DirectIOImpl(name);
        if (mode) {
            ret = MappingioInstance.getInstance(ret);
        }
        return ret;
    }

    public static final Baseio openEmulation(String name) throws Exception {
        return RawioInstance.openEmulation(false, name);
    }

    public static final Baseio openEmulation(boolean mode, String name) throws Exception {
        Baseio ret = new EmulationRawIOImpl(name);
        if (mode) {
            ret = MappingioInstance.getInstance(ret);
        }
        return ret;
    }

    public static final int getSector(String name) throws Exception {
        if (!NativeRawIO.useInit()) {
            return 512;
        }
        String path = DirectIOImpl.getPath(name);
        int ret = NativeRawIO.getSector(NativeRawIO.nativeString(path));
        if (ret <= -1) {
            throw new IOException("\u30bb\u30af\u30bf\u9577\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        return ret;
    }
}

