//
// HTMLタグスクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// イベント処理.
////////////////////////////////////////////////////////////////////////////////
Event = {
    event : function( event,value ) {
        if( __$type$script != "script" ) {
            return "" ;
        }
        return new StrBuf().ad( event ).ad( "='javascript:" ).
            ad( org.maachang.comet.httpd.engine.script.js.JsDef.convetByCote( false,value ) ).
            ad( "'" ).ts() ;
    },
    // onclick.
    onclick : function( value ) {
        return this.event( "onclick",value ) ;
    },
    // ondblclick.
    ondblclick : function( value ) {
        return this.event( "ondblclick",value ) ;
    },
    // onkeydown.
    onkeydown : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeypress.
    onkeypress : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeyup.
    onkeyup : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onkeyup.
    onkeyup : function( value ) {
        return this.event( "onkeydown",value ) ;
    },
    // onmousedown.
    onmousedown : function( value ) {
        return this.event( "onmousedown",value ) ;
    },
    // onmouseup.
    onmouseup : function( value ) {
        return this.event( "onmouseup",value ) ;
    },
    // onmouseover.
    onmouseover : function( value ) {
        return this.event( "onmouseover",value ) ;
    },
    // onmouseout.
    onmouseout : function( value ) {
        return this.event( "onmouseout",value ) ;
    },
    // onmousemove.
    onmousemove : function( value ) {
        return this.event( "onmousemove",value ) ;
    },
    // onload.
    onload : function( value ) {
        return this.event( "onload",value ) ;
    },
    // onunload.
    onunload : function( value ) {
        return this.event( "onunload",value ) ;
    },
    // onfocus.
    onfocus : function( value ) {
        return this.event( "onfocus",value ) ;
    },
    // onblur.
    onblur : function( value ) {
        return this.event( "onblur",value ) ;
    },
    // onsubmit.
    onsubmit : function( value ) {
        return this.event( "onsubmit",value ) ;
    },
    // onreset.
    onreset : function( value ) {
        return this.event( "onreset",value ) ;
    },
    // onchange.
    onchange : function( value ) {
        return this.event( "onchange",value ) ;
    },
    // onresize.
    onresize : function( value ) {
        return this.event( "onresize",value ) ;
    },
    // onmove.
    onmove : function( value ) {
        return this.event( "onmove",value ) ;
    },
    // ondragdrop.
    ondragdrop : function( value ) {
        return this.event( "ondragdrop",value ) ;
    },
    // onabort.
    onabort : function( value ) {
        return this.event( "onabort",value ) ;
    },
    // onerror.
    onerror : function( value ) {
        return this.event( "onerror",value ) ;
    },
    // onselect.
    onselect : function( value ) {
        return this.event( "onselect",value ) ;
    }
} ;

////////////////////////////////////////////////////////////////////////////////
// メッセージタグ.
////////////////////////////////////////////////////////////////////////////////

// Validateエラーメッセージ表示用タグ.
errorTag = function(id) {
    if( __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = "main" ;
        }
        if( useString( _$script$query.get('_validateError'+id) ) == true ) {
            return new StrBuf().ad("<div id=\"emsgId").ad(id).ad("\" class=\"emsg\" style=\"color:red;\">").
                ad(_$script$query.get('_validateError'+id)).
                ad("</div>").ts() ;
        }
        else {
            return new StrBuf().ad("<div id=\"emsgId" ).ad(id).ad("\" class=\"emsg\" style=\"color:red;\"></div>").ts() ;
        }
    }
    return "" ;
} ;

// 正常メッセージ表示用タグ.
successTag = function(id) {
    if( __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = "main" ;
        }
        if( useString( _$script$query.get('_validateSuccess'+id) ) == true ) {
            return new StrBuf().ad("<div id=\"smsgId").ad(id).
                ad("\" class=\"smsg\" style=\"color:blue;\">").
                ad(_$script$query.get('_validateSuccess'+id)).
                ad("</div>").ts() ;
        }
        else {
            return new StrBuf().ad("<div id=\"smsgId").ad(id).
            ad("\" class=\"smsg\" style=\"color:blue;\">&nbsp;</div>").ts() ;
        }
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// HTMLタグ関連.
////////////////////////////////////////////////////////////////////////////////

// Inputタグの名前保存用.
var _$tagInputNames = [] ;

// 現在のパラメータをhiddenタグに付加.
outputHiddenQuery = function() {
    var buf = new StrBuf() ;
    var it = _$script$query.keySet().iterator() ;
    while( it.hasNext() ) {
        var one = it.next() ;
        if( isNull( one ) || startsWith( one,"_" ) || startsWith( one,"$" ) ) {
            continue ;
        }
        buf.append( hiddenTag( one ) ) ;
    }
    return buf.ts() ;
}

// その他情報を展開.
etcTag = function( etc,buf ) {
    if( isNull( etc ) ) {
        return "" ;
    }
    var noBuf = false ;
    if( isNull( buf ) ) {
        noBuf = true ;
        buf = new StrBuf() ;
    }
    var t = valueof( etc ) ;
    if( t == "string" ) {
        buf.append( " " ).append( etc ).append( " " ) ;
        if(noBuf == true ) {
            return buf.ts() ;
        }
        else {
            return "" ;
        }
    }
    else if( t == "map" ) {
        buf.ad( " " ) ;
        for( var k in etc ) {
            if( isNull( etc[k] ) == false && useString( etc[k] ) == true ) {
                buf.ad( k ).ad( "=" ).ad( "\"" ).ad( etc[k] ).ad( "\" " ) ;
            }
        }
        if(noBuf == true ) {
            return buf.ts() ;
        }
        else {
            return "" ;
        }
    }
    else if( t == "array" ) {
        buf.ad( " " ) ;
        var len = etc.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            buf.ad( etc[ i ] ).ad( " " ) ;
        }
        if(noBuf == true ) {
            return buf.ts() ;
        }
        else {
            return "" ;
        }
    }
} ;

// リンク指定時に利用.
viewHref = function(href) {
    var buf = new StrBuf() ;
    var p = -1 ;
    if( ( p = href.indexOf( "?" ) ) == -1 ) {
        if( isSessionLink() == false && getSessionId() != null ) {
            buf.ad( href ).ad( "?t=" ).ad( new Date().getTime() ).ad( "&" ).
            ad( sessionParam() ).ad( "=" ).ad( getSessionId() ) ;
        }
        else {
            buf.ad( href ).ad( "?t=" ).ad( new Date().getTime() ) ;
        }
        href = buf.ts() ;
        buf.clear() ;
    }
    else {
        var a = href.substring( 0,p ) ;
        var b = href.substring( p+1 ) ;
        if( b.indexOf( "%" ) == -1 ) {
            b = urlEncode( b ) ;
        }
        if( isSessionLink() == false && getSessionId() != null ) {
            buf.ad( a ).ad( "?t=" ).ad( new Date().getTime() ).ad( "&" ).
            ad( sessionParam() ).ad( "=" ).ad( getSessionId() ).ad( "&" ).ad( b ) ;
        }
        else {
            buf.ad( a ).ad( "?t=" ).ad( new Date().getTime() ).ad( "&" ).ad( b ) ;
        }
        a = null ;
        b = null ;
        href = buf.ts() ;
        buf.clear() ;
    }
    p = null ;
    if( startsWith( href,"http://" ) || startsWith( href,"https://" ) ) {
        return href ;
    }
    else {
        return margePathName(href) ;
    }
}

// 現在のカレント名から、フォーム名を生成.
getFormNameByCurrentName = function() {
    var ret = currentName() ;
    var p = ret.lastIndexOf( "/" ) ;
    if( p >= 0 ) {
        ret = ret.substring( p+1 ) ;
    }
    p = ret.indexOf( "." ) ;
    if( p >= 0 ) {
        ret = ret.substring( 0,p ) ;
    }
    ret = trim( ret ) ;
    if( endsWith( ret,"Controller" ) ) {
        ret = ret.substring( 0,ret.length - "Controller".length ) ;
    }
    return ret + "Form" ;
}

// hiddenセット時のコンバート.
hiddenConvert = function( value ) {
    if( valueof( value ) == "date" ) {
        return "__$formatter@date@=" + value.getTime() ;
    }
    return parseValue( org.maachang.comet.httpd.engine.script.js.JsDef.convertByViewHtml( false,value ) ) ;
}

// イメージキャッシュ時間を取得.
imageCacheTime = function( mode ) {
    if( mode == false ) {
        return java.lang.System.currentTimeMillis() ;
    }
    if( getConfig( "server","image-cache" ) == true ) {
        return null ;
    }
    return java.lang.System.currentTimeMillis() ;
}

// charset定義.
charsetTag = function(charset,mime) {
    if( __$type$script == "script" ) {
        if( useString( charset ) == false ) {
            charset = "utf-8" ;
        }
        charset = trim( charset ) ;
        if( useString( mime ) == false ) {
            mime = "text/html" ;
        }
        if( endsWith( mime,";" ) == false ) {
            mime += ";" ;
        }
        return new StrBuf().ad( "<meta http-equiv=\"content-type\" content=\"" ).ad( mime ).
            ad( " charset=" ).ad( charset ).ad( "\">" ).ts() ;
    }
    return "" ;
} ;

// favicon.ico表示設定用.
iconTag = function(path,cmode) {
    if( __$type$script == "script" ) {
        if( useString( path ) == false ) {
            path = "/" ;
        }
        else {
            path = trim( path ) ;
            if( path.length > 0 && startsWith( path,"/" ) == false ) {
                path = "/" + path ;
            }
            if( path.length > 0 && endsWith( path,"/" ) == false ) {
                path += "/" ;
            }
        }
        var time = imageCacheTime( cmode ) ;
        if( isNull( time ) ) {
            return new StrBuf().ad( "<link rel=\"shortcut icon\" href=\"" ).
                ad( path ).ad( "favicon.ico\">" ).ts() ;
        }
        else {
            return new StrBuf().ad( "<link rel=\"shortcut icon\" href=\"" ).
                ad( path ).ad( "favicon.ico" ).ad( "?" ).ad( time ).ad( "\">" ).ts() ;
        }
    }
    return "" ;
} ;

// JavaScript読み込み用タグ.
scriptTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var buf = new StrBuf().ad( name ) ;
        var x = toLowerCase( name ) ;
        if( endsWith( name,".js" ) == false ) {
            buf.ad( ".js" ) ;
        }
        if( isSessionLink() == false && getSessionId() != null ) {
            buf.ad( "?t=" ).ad( new Date().getTime() ).ad( "&" ).
                ad( sessionParam() ).ad( "=" ).ad( getSessionId() ) ;
        }
        else {
            buf.ad( "?t=" ).ad( new Date().getTime() ) ;
        }
        name = buf.ts() ;
        buf.clear() ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return buf.ad( "<script language=\"javascript\" type=\"text/javascript\" src=\"" ).
                ad( name ).ad( "\"></script>" ).ts() ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return buf.ad( "<script language=\"javascript\" type=\"text/javascript\" src=\"/js/" ).
                ad( name ).ad( "\"></script>" ).ts() ;
        }
    }
    return "" ;
} ;

// CSS読み込み用タグ.
styleTag = function(name) {
    if( useString( name ) == true && __$type$script == "script" ) {
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            return new StrBuf().ad( "<link rel=\"stylesheet\" href=\"" ).ad( name ).ad( "?" ).
                ad( new Date().getTime() ).ad( "\" type=\"text/css\"/>" ).ts() ;
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            return new StrBuf().ad( "<link rel=\"stylesheet\" href=\"/style/" ).ad( name ).ad( "?" ).
                ad( new Date().getTime() ).ad( "\" type=\"text/css\"/>" ).ts() ;
        }
    }
    return "" ;
} ;

// Javascript初期化タグ.
initScriptTag = function() {
    if( __$type$script == "script" ) {
        var buf = new StrBuf() ;
        buf.ad( "<script>\n" ) ;
        buf.ad( "var $scriptParams = {\n" ) ;
        if( isSession() ) {
            buf.ad( "    sessionId :" ).ad( "\'" ).ad( getSessionId() ).ad( "\'" ) ;
        }
        if( isRequestParam() ) {
            var it = _$script$query.keySet().iterator() ;
            var flag = false ;
            while( it.hasNext() ) {
                var key = it.next() ;
                if( startsWith( key,"_" ) || key.indexOf( "." ) >= 0 ) {
                    continue ;
                }
                if( flag == true ) {
                    buf.ad( ",\n" ) ;
                }
                flag = false ;
                var val = _$script$query.get( key ) ;
                if( val instanceof java.util.ArrayList ) {
                    buf.ad( "    " ).ad( key ).ad( " : [" ) ;
                    var lenJ = val.size() ;
                    for( var j = 0 ; j < lenJ ; j ++ ) {
                        if( j != 0 ) {
                            buf.ad( "," ) ;
                        }
                        buf.ad( "\'" ).ad( val.get( j ) ).ad( "\'" ) ;
                    }
                    buf.ad( "]" ) ;
                }
                else {
                    buf.ad( "    " ).ad( key ).ad( " : \'" ).ad( val ).ad( "\'" ) ;
                }
                flag = true ;
            }
        }
        return buf.ad( "\n} ;\n" ).ad( "</script>\n" ).ts() ;
    }
    return "" ;
} ;

// ダミーフレーム.
dummyFrame = function( name ) {
    if( useString( name ) == true && __$type$script == "script" ) {
        return new StrBuf().ad( "<iframe id='" ).ad( name ).ad( "Id' name='" ).ad( name ).ad( "' width=0 height=0 border=0 " ).
            ad( "marginheight=0 marginwidth=0 frameborder=0 hspace=0></iframe>" ).ts() ;
    }
    return "" ;
} ;

// 通常のimage読み込み用タグ.
imageTag = function(name,alt,border,width,height,etc,cmode) {
    if( useString( name ) == true && __$type$script == "script" ) {
        var buf = new StrBuf() ;
        name = trim( name ) ;
        var x = toLowerCase( name ) ;
        var time = imageCacheTime( cmode ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( "<img src=\"" ).ad( name ).ad( "\"" ) ;
            }
            else {
                if( name.indexOf( "?" ) >= 0 ) {
                    buf.ad( "<img src=\"" ).ad( name ).ad( "&" ).ad( time ).ad( "\"" ) ;
                }
                else {
                    buf.ad( "<img src=\"" ).ad( name ).ad( "?" ).ad( time ).ad( "\"" ) ;
                }
            }
        }
        else {
            if( startsWith( name,"/" ) ) {
                name = name.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "<img src=\"/img/" ).ad( name ).ad( "\"" ) ;
            }
            else {
                if( name.indexOf( "?" ) >= 0 ) {
                    buf.ad( "<img src=\"/img/" ).ad( name ).ad( "&" ).ad( time ).ad( "\"" ) ;
                }
                else {
                    buf.ad( "<img src=\"/img/" ).ad( name ).ad( "?" ).ad( time ).ad( "\"" ) ;
                }
            }
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// 画像サーバ側生成用img読み込みタグ.
serverImgTag = function(name,alt,border,width,height,etc,id) {
    if( __$type$script == "script" ) {
        if( useString( name ) == false ) {
            name = "/img/maachang/clear.gif" ;
        }
        else {
            name = trim( name ) ;
            name = viewHref(name) ;
        }
        var buf = new StrBuf().ad( "<img src=\"" ).ad( name ).ad( "\"" ) ;
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        if( isNull( id ) == false ) {
            buf.ad( " id=\"_img_" ).ad( id ).ad( "Id\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// DIVタグ.
idTag = function( id,etc ) {
    if( useString( id ) == true && __$type$script == "script" ) {
        return new StrBuf().ad( "<div id=\"" ).ad( id ).ad( "\" " ).
            ad( etcTag( etc ) ).ad( ">&nbsp;</div>" ).ts() ;
    }
    return "" ;
} ;

// spanタグ.
spanTag = function( id,etc ) {
    if( useString( id ) == true && __$type$script == "script" ) {
        return new StrBuf().ad( "<span id=\"" ).ad( id ).ad( "\" " ).
            ad( etcTag( etc ) ).ad( ">&nbsp;</span>" ).ts() ;
    }
    return "" ;
} ;

// リンクタグ.
linkTag = function( href,view,etc,mode ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var buf = new StrBuf() ;
        href = viewHref(href) ;
        buf.ad( "<a href=\"" ).ad( href ).ad( "\" " ) ;
        etcTag( etc,buf ) ;
        if( isNull( mode ) == false && parseValue( mode ) == true ) {
            buf.ad( " target=\"_blank\" " ) ;
        }
        buf.ad( ">" ) ;
        if( useString( view ) ) {
            buf.ad( view ) ;
        }
        return buf.ad( "</a>" ).ts() ;
    }
    return "" ;
} ;

// 開始リンクタグ.
startLinkTag = function( href,etc,mode ) {
    if( useString( href ) == true && __$type$script == "script" ) {
        var buf = new StrBuf() ;
        href = viewHref(href) ;
        buf.ad( "<a href=\"" ).ad( href ).ad( "\" " ) ;
        etcTag( etc,buf ) ;
        if( isNull( mode ) == false && parseValue( mode ) == true ) {
            buf.ad( " target=\"_blank\" " ) ;
        }
        buf.ad( ">" ) ;
        return buf.ts() ;
    }
    return "" ;
} ;

// 終了リンクタグ.
endLinkTag = function() {
    if( __$type$script == "script" ) {
        return "</a>" ;
    }
    return "" ;
}

// form開始タグ.
startForm = function( action,name,method,target,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var buf = new StrBuf() ;
        if( useString( method ) == false ) {
            method = "POST" ;
        }
        buf.ad( "<form " + "method=\"" ).ad( method ).ad( "\" action=\"" ).ad( margePathName(action) ).ad( "\" " ) ;
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\" " ) ;
        }
        else {
            buf.ad( " name=\"" ).ad( getFormNameByCurrentName() ).ad( "\" " ) ;
        }
        if( useString( target ) ) {
            buf.ad( " target=\"" ).ad( target ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            buf.ad( " >\n" ).ad( "<input type=\"hidden\" name=\"" ).ad( sessionParam() ).
                ad( "\" value=\"" ).ad( getSessionId() ).ad( "\">" ) ;
        }
        else {
            buf.ad( " >" ) ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return buf.ts() ;
    }
    return "" ;
} ;

// MultiPartForm開始タグ.
multiForm = function( action,name,target,etc ) {
    if( useString( action ) == true && __$type$script == "script" ) {
        var buf = new StrBuf() ;
        buf.ad( "<form " + "method=\"POST\" action=\"" ).ad( margePathName(action) ).ad( "\" enctype=\"multipart/form-data\" " ) ;
        if( useString( name ) ) {
            buf.ad( "name=\""+name+"\" " ) ;
        }
        else {
            name = getFormNameByCurrentName() ;
            buf.ad( "name=\"" ).ad( name ).ad( "\" " ) ;
        }
        if( useString( target ) ) {
            buf.ad( "target=\"" ).ad( target ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        if( isSessionLink() == false && getSessionId() != null ) {
            buf.ad( ">\n" ).ad( "<input type=\"hidden\" name=\"" ).ad( sessionParam() ).ad( "\" value=\"" ).ad( getSessionId() ).ad( "\">" ) ;
        }
        else {
            buf.ad( " >" ) ;
        }
        // inputタグ系の情報を初期化.
        _$tagInputNames = [] ;
        return buf.ts() ;
    }
    return "" ;
} ;

// 終了タグ.
endForm = function(mode) {
    if( __$type$script == "script" ) {
        if( isNull( mode ) == false && mode == true ) {
            var buf = new StrBuf() ;
            var it = _$script$query.keySet().iterator() ;
            while( it.hasNext() ) {
                var one = it.next() ;
                if( isNull( one ) || startsWith( one,"_" ) ||
                    startsWith( one,"$" ) ||
                    startsWith( one,"submitButton." ) ) {
                    continue ;
                }
                else {
                    var lenJ = _$tagInputNames.length ;
                    var flg = false ;
                    for( var j = 0 ; j < lenJ ; j ++ ) {
                        if( _$tagInputNames[ j ] == one ) {
                            flg = true ;
                            break ;
                        }
                    }
                    if( flg == true ) {
                        continue ;
                    }
                }
                buf.ad( hiddenTag( one ) ) ;
            }
            _$tagInputNames = [] ;
            return buf.ad( "</form>" ).ts() ;
        }
        else {
            _$tagInputNames = [] ;
            return "</form>" ;
        }
    }
    return "" ;
} ;

// submitボタン.
submitButton = function( value,name ) {
    if( __$type$script == "script" ) {
        var buf = new StrBuf() ;
        if( useString( name ) == false ) {
            buf.ad( "<input type=\"submit\" class=\"_button_clazz\" " ) ;
        }
        else {
            buf.ad( "<input type=\"submit\" class=\"_button_clazz\" name=\"" ).
                ad( name ).ad( "\" id=\"" ).ad( name ).ad( "Id\" " ) ;
        }
        if( useString( value ) == true ) {
            buf.ad( "value=\"" ).ad( value ).ad( "\" " ) ;
        }
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// resetボタン.
resetButton = function( value,name ) {
    if( __$type$script == "script" ) {
        var buf = new StrBuf() ;
        if( useString( name ) == false ) {
            buf.ad( "<input type=\"reset\" class=\"_button_clazz\" " ) ;
        }
        else {
            buf.ad( "<input type=\"reset\" class=\"_button_clazz\" name=\"" ).ad( name ).ad( "\" id=\"" ).ad( name ).ad( "Id\" " ) ;
        }
        if( useString( value ) == true ) {
            buf.ad( "value=\"" ).ad( value ).ad( "\" " ) ;
        }
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// 画像ボタン.
imgButton = function(name,src,alt,border,width,height,etc,cmode) {
    if( useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var time = imageCacheTime( cmode ) ;
        var x = toLowerCase( src ) ;
        var buf = new StrBuf().ad( "<input type=\"image\" src=\"" ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "/img/" ).ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( "/img/" ).ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\"" ) ;
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// 画像リンクボタン.
imgLinkButton = function(name,src,href,alt,border,width,height,etc,cmode) {
    if( useString( src ) == true && __$type$script == "script" ) {
        src = trim( src ) ;
        var time = imageCacheTime( cmode ) ;
        var x = toLowerCase( src ) ;
        var buf = new StrBuf().ad( "<input type=\"image\" src=\"" ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "/img/" ).ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( "/img/" ).ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\"" ) ;
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        if( useString( href ) ) {
            buf.ad( " onclick=\"location.href='" ).ad( viewHref(href) ).ad( "'\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// 画像Submitボタン.
imgSubmitButton = function(name,src,formName,alt,border,width,height,etc,cmode) {
    if( useString( src ) == true && __$type$script == "script" ) {
        var time = imageCacheTime( cmode ) ;
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var buf = new StrBuf().ad( "<input type=\"image\" src=\"" ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "/img/" ).ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( "/img/" ).ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\"" ) ;
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        buf.ad( " onclick=\"document." ).ad( formName ).ad( ".submit()\"" ) ;
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// 画像リセットボタン.
imgResetButton = function(name,src,formName,alt,border,width,height,etc,cmode) {
    if( useString( src ) == true && __$type$script == "script" ) {
        var time = imageCacheTime( cmode ) ;
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var buf = new StrBuf().ad( "<input type=\"image\" src=\"" ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "/img/" ).ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( "/img/" ).ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\"" ) ;
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        if( useString( formName ) ) {
            buf.ad( " onclick=\"document." ).ad( formName ).ad( ".reset()\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// ボタン.
button = function( value,etc,name ) {
    if( __$type$script == "script" ) {
        var buf = new StrBuf() ;
        if( useString( name ) == false ) {
            buf.ad( "<input type=\"button\" class=\"_button_clazz\" " ) ;
        }
        else {
            buf.ad( "<input type=\"button\" class=\"_button_clazz\" name=\"" ).
                ad( name ).ad( "\" id=\"" ).ad( name ).ad( "Id\" " ) ;
        }
        if( useString( value ) == true ) {
            buf.ad( "value=\"" ).ad( value ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// リンクボタン.
linkButton = function( value,href,etc,name ) {
    if( __$type$script == "script" ) {
        var buf = new StrBuf() ;
        if( useString( name ) == false ) {
            buf.ad( "<input type=\"button\" class=\"_button_clazz\" " ) ;
        }
        else {
            buf.ad( "<input type=\"button\" class=\"_button_clazz\" name=\"" ).
                ad( name ).ad( "\" id=\"" ).ad( name ).ad( "Id\" " ) ;
        }
        if( useString( value ) == true ) {
            buf.ad( "value=\"" ).ad( value ).ad( "\" " ) ;
        }
        if( useString( href ) ) {
            buf.ad( " onclick=\"location.href='" ).ad( viewHref(href) ).ad( "'\"" ) ;
        }
        etcTag( etc,buf ) ;
        return buf.ad( " >" ).ts() ;
    }
    return "" ;
} ;

// Hiddenタグ.
hiddenTag = function(name,value,id,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf() ;
        buf.ad( "<input type=\"hidden\" name=\"" ).ad( name ).ad( "\" " ) ;
        etcTag( etc,buf ) ;
        if( useString( value ) == true ) {
            if( useString( id ) ) {
                buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
            }
            buf.ad( "value=\"" ).ad( hiddenConvert( value ) ).ad( "\" >\n" ) ;
        }
        else {
            var addFlag = false ;
            var val = _$script$query.get( name ) ;
            if( isNull( val ) == false ) {
                if( ( val instanceof java.util.List ) == false ) {
                    if( useString( id ) ) {
                        buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
                    }
                    buf.ad( "value=\"" ).ad( hiddenConvert( parseValue(val) ) ).ad( "\" >\n" ) ;
                    addFlag = true ;
                }
                else {
                    var tmp = buf.ts() ;
                    buf.clear() ;
                    var len = val.size() ;
                    for( var i = 0 ; i < len ; i ++ ) {
                        buf.ad( tmp ) ;
                        if( useString( id ) ) {
                            buf.ad( "id=\"" ).ad( id ).ad( "_" ).ad( i ).ad( "\" " ) ;
                        }
                        buf.ad( "value=\"" ).ad( hiddenConvert( parseValue(val.get( i )) ) ).ad( "\" >\n" ) ;
                        addFlag = true ;
                    }
                }
            }
            if( addFlag == false ) {
                buf.ad( " >\n" ) ;
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ts() ;
    }
    return "" ;
} ;

// テキストエリアタグ.
textAreaTag = function(name,id,clazz,cols,rows,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<textarea name=\"" ).ad( name ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNumeric( cols ) ) {
            buf.ad( "cols=\"" ).ad( cols ).ad( "\" " ) ;
        }
        if( isNumeric( rows ) ) {
            buf.ad( "rows=\"" ).ad( rows ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        buf.ad( ">" ) ;
        if( useString( _$script$query.get( name ) ) ) {
            buf.ad( $html( parseValue( _$script$query.get( name ) ),false ) ) ;
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( "</textarea>" ).ts() ;
    }
    return "" ;
} ;

// テキストタグ.
textTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<input type=\"text\" name=\"" ).ad( name ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNumeric( size ) ) {
            buf.ad( "size=\"" ).ad( size ).ad( "\" " ) ;
        }
        if( isNumeric( max ) ) {
            buf.ad( "maxlength=\"" ).ad( max ).ad( "\" " ) ;
        }
        if( useString( _$script$query.get( name ) ) ) {
            buf.ad( "value=\"" ).ad( parseValue( _$script$query.get( name ) ) ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;
} ;

// パスワードタグ.
passwordTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<input type=\"password\" name=\"" ).ad( name ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNumeric( size ) ) {
            buf.ad( "size=\"" ).ad( size ).ad( "\" " ) ;
        }
        if( isNumeric( max ) ) {
            buf.ad( "maxlength=\"" ).ad( max ).ad( "\" " ) ;
        }
        //if( useString( _$script$query.get( name ) ) ) {
        //    buf.ad( "value=\"" ).ad( parseValue( _$script$query.get( name ) ) ).ad( "\" " ) ;
        //}
        etcTag( etc,buf ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;

} ;

// ファイルタグ.
fileTag = function(name,id,clazz,size,max,etc) {
    if( useString( name ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<input type=\"file\" name=\"" ).ad( name ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNumeric( size ) ) {
            buf.ad( "size=\"" ).ad( size ).ad( "\" " ) ;
        }
        if( isNumeric( max ) ) {
            buf.ad( "maxlength=\"" ).ad( max ).ad( "\" " ) ;
        }
        etcTag( etc,buf ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;
} ;

// チェックボックスタグ.
checkBoxTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<input type=\"checkbox\" name=\"" ).ad( name ).
            ad( "\" value=\"" ).ad( value ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( ( lst instanceof java.util.List ) == false ) {
                lst = parseValue( lst ) ;
                if( lst == value ) {
                    buf.ad( "checked " ) ;
                }
            }
            else {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = parseValue( lst.get( i ) ) ;
                    if( isNull( s ) == false && useString( s ) == true && s == value ) {
                        buf.ad( "checked " ) ;
                        break ;
                    }
                }
            }
        }
        etcTag( etc,buf ) ;
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;
} ;

// ラジオボタンタグ.
radioTag = function(name,value,id,clazz,etc ) {
    if( useString( name ) == true && useString( value ) == true && __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        var buf = new StrBuf().ad( "<input type=\"radio\" name=\"" ).ad( name ).
            ad( "\" value=\"" ).ad( value ).ad( "\" " ) ;
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( isNull( _$script$query.get(name) ) == false ) {
            var lst = _$script$query.get(name) ;
            if( ( lst instanceof java.util.List ) == false ) {
                lst = parseValue( lst ) ;
                if( lst == value ) {
                    buf.ad( "checked " ) ;
                }
            }
            else {
                var len = lst.size() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var s = parseValue( lst.get( i ) ) ;
                    if( isNull( s ) == false && useString( s ) == true && s == value ) {
                        buf.ad( "checked " ) ;
                        break ;
                    }
                }
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        etcTag( etc,buf ) ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;
} ;

// セレクトタグ.
selectTag = function(name,view,size,multiple,id,clazz,etc) {
    if( useString( name ) == true && ( valueof( view ) == "map" || valueof( view ) == "array" ) &&
        __$type$script == "script" ) {
        if( useString( id ) == false ) {
            id = name + "Id" ;
        }
        buf = new StrBuf().ad( "<select name=\"" ).ad( name ).ad( "\" id=\"" ).ad( id ).ad( "\" " ) ;
        if( isNumeric( size ) ) {
            buf.ad( "size=\"" ).ad( size ).ad( "\" " ) ;
            if( size == 1 ) {
                size = null ;
            }
        }
        else {
            size = null ;
        }
        if( useString( id ) ) {
            buf.ad( "id=\"" ).ad( id ).ad( "\" " ) ;
        }
        if( useString( clazz ) ) {
            buf.ad( "class=\"" ).ad( clazz ).ad( "\" " ) ;
        }
        if( size != null && isNull( multiple ) == false && multiple == true ) {
            buf.ad( "multiple " ) ;
        }
        etcTag( etc,buf ) ;
        buf.ad( ">\n" ) ;
        var t = valueof( view ) ;
        if( t == "map" ) {
            var lst = _$script$query.get(name) ;
            if( isNull( lst ) ) {
                for( var k in view ) {
                    buf.ad( "    <option value=\"" ).ad( k ).ad( "\">" ).ad( view[k] ).ad( "</option>\n" ) ;
                }
            }
            else {
                if( ( lst instanceof java.util.List ) == false ) {
                    lst = parseValue( lst ) ;
                    for( var k in view ) {
                        buf.ad( "    <option value=\"" ).ad( k ).ad( "\" " ) ;
                        if( lst == k ) {
                            buf.ad( "selected " ) ;
                        }
                        buf.ad( ">" ).ad( view[k] ).ad( "</option>\n" ) ;
                    }
                }
                else {
                    for( var k in view ) {
                        buf.ad( "    <option value=\"" ).ad( k ).ad( "\" " ) ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var s = parseValue( lst.get( i ) ) ;
                            if( isNull( s ) == false && useString( s ) == true && s == k ) {
                                buf.ad( "selected " ) ;
                                break ;
                            }
                        }
                        buf.ad( ">" ).ad( view[k] ).ad( "</option>\n" ) ;
                    }
                }
            }
        }
        else if( t == "array" ) {
            var lst = _$script$query.get(name) ;
            var len = view.length ;
            if( isNull( lst ) ) {
                for( var i = 0 ; i < len ; i += 2 ) {
                    var k = view[ i ] ;
                    var v = view[ i + 1 ] ;
                    buf.ad( "    <option value=\"" ).ad( k ).ad( "\">" ).ad( v ).ad( "</option>\n" ) ;
                }
            }
            else {
                if( ( lst instanceof java.util.List ) == false ) {
                    lst = parseValue( lst ) ;
                    for( var i = 0 ; i < len ; i += 2 ) {
                        var k = view[ i ] ;
                        var v = view[ i + 1 ] ;
                        buf.ad( "    <option value=\"" ).ad( k ).ad( "\" " ) ;
                        if( lst == k ) {
                            buf.ad( "selected " ) ;
                        }
                        buf.ad( ">" ).ad( v ).ad( "</option>\n" ) ;
                    }
                }
                else {
                    for( var k in view ) {
                        buf.ad( "    <option value=\"" ).ad( k ).ad( "\" " ) ;
                        for( var i = 0 ; i < len ; i ++ ) {
                            var k = view[ i ] ;
                            var v = view[ i + 1 ] ;
                            var s = parseValue( lst.get( i ) ) ;
                            if( isNull( s ) == false && useString( s ) == true && s == k ) {
                                buf.ad( "selected " ) ;
                                break ;
                            }
                        }
                        buf.ad( ">" ).ad( v ).ad( "</option>\n" ) ;
                    }
                }
            }
        }
        _$tagInputNames[ _$tagInputNames.length ] = name ;
        return buf.ad( "</select>" ).ts() ;
    }
    return "" ;
}

// ページング内容キャッシュ.
var _$cache$_viewPageing = null ;
// ページング内容を生成.
viewPageing = function( href,pos,max,addParams,space,targetClazz,etcClazz,viewSize,viewPageing ) {
    if( useString( href ) == false || max <= 0 ) {
        return "" ;
    }
    // ページング生成キャッシュが既に存在する場合.
    if( isNull( _$cache$_viewPageing ) == false ) {
        // キャッシュ内容と同じ引数内容である場合は、キャッシュを返す.
        var x = _$cache$_viewPageing ;
        if( isNull( x.cache ) == false &&
            x.href == href && x.pos == pos && x.max == max &&
            x.addParams == addParams && x.space == space &&
            x.targetClass == targetClazz && x.etcClazz == etcClazz &&
            x.viewSize == viewSize && x.viewPageing == viewPageing ) {
            return x.cache ;
        }
        // キャッシュ内容と違う引数内容の場合は、破棄して、
        // 今回の内容をキャッシュ内容にする.
        else {
            _$cache$_viewPageing = {
                href:href,pos:pos,max:max,addParams:addParams,
                space:space,targetClazz:targetClazz,etcClazz:etcClazz,
                viewSize:viewSize,viewPageing:viewPageing,cache:null } ;
        }
    }
    // ページング生成キャッシュが存在しない場合.
    else {
        _$cache$_viewPageing = {
            href:href,pos:pos,max:max,addParams:addParams,
            space:space,targetClazz:targetClazz,etcClazz:etcClazz,
            viewSize:viewSize,viewPageing:viewPageing,cache:null } ;
    }
    
    if( useString( targetClazz ) == false ) {
        targetClazz = "page_target_view" ;
    }
    if( useString( etcClazz ) == false ) {
        etcClazz = "page_link_view" ;
    }
    if( isNull( viewSize ) ) {
        viewSize = 10 ;
    }
    if( isNull( viewPageing ) ) {
        viewPageing = 13 ;
    }
    else if( ( viewPageing & 0x00000001 ) == 0 ) {
        viewPageing ++ ;
    }
    if( max <= viewSize ) {
        return "" ;
    }
    if( isNull( space ) ) {
        space = 1 ;
    }
    if( isNull( addParams ) == false ) {
        if( href.indexOf( "?" ) != -1 ) {
            href += "&" ;
        }
        else {
            href += "?" ;
        }
    }
    else {
        href += "?" ;
    }
    var targetPos = parseInt( pos / viewSize ) ;
    var len = viewPageing ;
    var maxPos = parseInt( ( max / viewSize ) + ( ( max % viewSize != 0 ) ? 1 : 0 ) ) ;
    var startPos = 0 ;
    if( len < maxPos ) {
        var half = parseInt( viewPageing / 2 ) ;
        startPos = targetPos - half ;
        if( startPos <= 0 ) {
            startPos = 0 ;
        }
        if( startPos + len > maxPos ) {
            startPos = maxPos - len ;
        }
    }
    else {
        len = maxPos ;
    }
    var spaceStr = "" ;
    for( var i = 0 ; i < space ; i ++ ) {
        spaceStr += "&nbsp;" ;
    }
    var buf = new StrBuf() ;
    startPos = parseInt( startPos ) ;
    for( var i = 0 ; i < len ; i ++ ) {
        if( i != 0 ) {
            buf.ad( spaceStr ) ;
        }
        var pageNo = ( startPos + i ) ;
        if( pageNo == targetPos ) {
            buf.ad( "<span class=\"" ).ad( targetClazz ).ad( "\">" ).ad(pageNo+1).ad( "</span>" ) ;
        }
        else {
            buf.ad( "<span class=\"" ).ad( etcClazz ).ad( "\">" ) ;
            if( isNull( addParams ) == false ) {
                buf.ad( startLinkTag( new StrBuf().ad( href ).
                    ad( convertMapToGetParams( addParams ) ).ad( "&" ).
                    ad( convertMapToGetParams( { pageNo:pageNo } ) ).ts() ) ) ;
            }
            else {
                buf.ad( startLinkTag( new StrBuf().ad( href ).
                    ad( convertMapToGetParams( { pageNo:pageNo } ) ).ts() ) ) ;
            }
            buf.ad(pageNo+1).ad( endLinkTag() ).ad( "</span>" ) ;
        }
    }
    var ret = buf.ts() ;
    buf = null ;
    _$cache$_viewPageing.cache = ret ;
    return ret ;
}

// 日付入力用Selectタグを生成.
selectYMD = function( name,yearOut,mode,year,month,day ) {
    if( useString( name ) == false ) {
        return "" ;
    }
    if( useString( year ) == false ) {
        year = "&nbsp;年&nbsp;" ;
    }
    if( useString( month ) == false ) {
        month = "&nbsp;月&nbsp;" ;
    }
    if( useString( day ) == false ) {
        day = "&nbsp;日" ;
    }
    if( isNull( mode ) || mode != true ) {
        mode = false ;
    }
    var buf = new StrBuf() ;
    
    // 年を生成.
    buf.ad( "<select name=\"" ).ad( name ).ad( "Year\" id=\"" ).ad( name ).ad( "YearId\" " ).
        ad( "onchange='javascript:$base.changeSelectYMD( \"" ).ad( name ).ad( "\" );' >\n" ) ;
    var n = new Date().getFullYear() ;
    var tg = _$script$query.get(name+"Year") ;
    var len = n + yearOut ;
    var y ;
    if( mode == false ) {
        buf.ad( "    <option value=\"\">選択\n" ) ;
    }
    if( yearOut <= 0 ) {
        if( isNull( tg ) == true ) {
            y = n ;
            for( var i = n ; i >= len ; i -- ) {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\">" ).ad( i ).ad( "\n" ) ;
            }
        }
        else {
            y = tg ;
            for( var i = n ; i >= len ; i -- ) {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\" " ) ;
                if( i == tg ) {
                    buf.ad( "selected " ) ;
                }
                buf.ad( ">" ).ad( i ).ad( "\n" ) ;
            }
        }
        buf.ad( "</select>\n" ) ;
    }
    else {
        if( isNull( tg ) == true ) {
            y = n ;
            for( var i = n ; i < len ; i ++ ) {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\">" ).ad( i ).ad( "\n" ) ;
            }
        }
        else {
            y = tg ;
            for( var i = n ; i < len ; i ++ ) {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\" " ) ;
                if( i == tg ) {
                    buf.ad( "selected " ) ;
                }
                buf.ad( ">" ).ad( i ).ad( "\n" ) ;
            }
        }
        buf.ad( "</select>\n" ) ;
    }
    buf.ad( year ).ad( "\n" ) ;
    
    // 月を生成.
    buf.ad( "<select name=\"" ).ad( name ).ad( "Month\" id=\"" ).ad( name ).ad( "MonthId\" " ).
        ad( "onchange='javascript:$base.changeSelectYMD( \"" ).ad( name ).ad( "\" );' >\n" ) ;
    n = new Date().getMonth() + 1 ;
    tg = _$script$query.get(name+"Month") ;
    var m ;
    if( mode == false ) {
        buf.ad( "    <option value=\"\">選択\n" ) ;
    }
    if( isNull( tg ) == true ) {
        m = n ;
        for( var i = 1 ; i <= 12 ; i ++ ) {
            var c = "00".substring( ( "" + i ).length ) + i ;
            if( mode == true && i == n ) {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\" selected>" ).ad( c ).ad( "\n" ) ;
            }
            else {
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\">" ).ad( c ).ad( "\n" ) ;
            }
        }
    }
    else {
        m = tg ;
        for( var i = 1 ; i <= 12 ; i ++ ) {
            var c = "00".substring( ( "" + i ).length ) + i ;
            buf.ad( "    <option value=\"" ).ad( i ).ad( "\" " ) ;
            if( i == tg ) {
                buf.ad( "selected " ) ;
            }
            buf.ad( ">" ).ad( c ).ad( "\n" ) ;
        }
    }
    buf.ad( "</select>\n" ) ;
    buf.ad( month ).ad( "\n" ) ;
    
    // 日を生成.
    buf.ad( "<select name=\"" ).ad( name ).ad( "Day\" id=\"" ).ad( name ).ad( "DayId\">\n" ) ;
    tg = _$script$query.get(name+"Day") ;
    if( mode == false && isNull( tg ) == true ) {
        buf.ad( "    <option value=\"\">選択\n" ) ;
    }
    else {
        var ymKey = new StrBuf().ad( y ).ad( "_" ).ad( m ).ts() ;
        len = null ;
        var st = new Date( y,m-1,1,0,0,0 ).getTime() ;
        m ++ ;
        if( m > 12 ) {
            m = 1 ;
            y ++ ;
        }
        var ed = new Date( y,m-1,1,0,0 ).getTime() ;
        len = parseInt( ( ed - st ) / 86400000 ) ;
        if( isNull( tg ) == true ) {
            n = new Date().getDate() ;
            for( var i = 1 ; i <= len ; i ++ ) {
                var c = "00".substring( ( "" + i ).length ) + i ;
                if( mode == true && i == n ) {
                    buf.ad( "    <option value=\"" ).ad( i ).ad( "\" selected>" ).ad( c ).ad( "\n" ) ;
                }
                else {
                    buf.ad( "    <option value=\"" ).ad( i ).ad( "\">" ).ad( c ).ad( "\n" ) ;
                }
            }
        }
        else {
            for( var i = 1 ; i <= len ; i ++ ) {
                var c = "00".substring( ( "" + i ).length ) + i ;
                buf.ad( "    <option value=\"" ).ad( i ).ad( "\" " ) ;
                if( i == tg ) {
                    buf.ad( "selected " ) ;
                }
                buf.ad( ">" ).ad( c ).ad( "\n" ) ;
            }
        }
    }
    buf.ad( "</select>\n" ) ;
    buf.ad( day ).ad( "\n" ) ;
    
    return buf.ts() ;
}

// 指定パラメータの英文字をカナ変換.
britishNumberToKanaByParam = function( name ) {
    if( useString( name ) == false ) {
        return "" ;
    }
    var v = _$script$query.get(name) ;
    return britishNumberToKana( v ) ;
}

// 指定Map情報をHTTP[GET]パラメータ情報に変換.
$mp = function( map,mode ) {
    return convertMapToGetParams( map,mode ) ;
}

// 指定Map情報をHTTP[GET]パラメータ情報に変換.
convertMapToGetParams = function( map,mode ) {
    if( __$type$script != "script" || valueof( map ) != "map" ) {
        return "" ;
    }
    var cnt = 0 ;
    var buf = new StrBuf() ;
    if( isNull( mode ) ) {
        mode = false ;
    }
    if( mode == true ) {
        buf.ad( "?" ) ;
    }
    for( var k in map ) {
        if( startsWith( k,"submitButton." ) ||
            ( startsWith( k,"_" ) && startsWith( k,"_validate" ) == false ) ||
            k == "t" ) {
            continue ;
        }
        if( cnt != 0 ) {
            buf.ad( "&" ) ;
        }
        var val = map[k] ;
        if( isNull( val ) || useString( val ) == false ) {
            buf.ad( k ).ad( "=" ) ;
        }
        else if( valueof( val ) == "array" ) {
            var len = val.length ;
            for( var i = 0 ; i < len ; i ++ ) {
                if( i != 0 ) {
                    buf.ad( "&" ) ;
                }
                buf.ad( k ).ad( "=" ).ad( encodeURL( val[ i ] ) ) ;
            }
        }
        else {
            buf.ad( k ).ad( "=" ).ad( encodeURL( val ) ) ;
        }
        cnt ++ ;
    }
    return buf.ts() ;
}

// Ｄａｔｅ内容から、日付情報で取得.
viewYyyyMmDd = function( date ) {
    if( isNull( date ) || valueof( date ) != "date" ) {
        return "" ;
    }
    var buf = new StrBuf().ad( date.getFullYear() ) ;
    var x = ""+(date.getMonth()+1) ;
    buf.ad( "/" + "00".substring( x.length,2 ) ).ad( x ) ;
    x = ""+date.getDate() ;
    buf.ad( "/" + "00".substring( x.length,2 ) ).ad( x ) ;
    return buf.ts() ;
}

// 指定Mapの日付情報を、Date型に変換.
convertMapByDate = function( name,map ) {
    if( useString( name ) == false || isNull( map ) ||
        isNumeric( map[name+"Year"] ) == false ||
        isNumeric( map[name+"Month"] ) == false ||
        isNumeric( map[name+"Day"] ) == false ) {
        return null ;
    }
    var year = map[name+"Year"] ;
    var month = map[name+"Month"] ;
    var day = map[name+"Day"] ;
    return new Date( year,month-1,day ) ;
}

// 指定パラメータの日付情報を、Date型に変換.
convertParamByDate = function( name ) {
    if( useString( name ) == false ||
        isNumeric( params[name+"Year"] ) == false ||
        isNumeric( params[name+"Month"] ) == false ||
        isNumeric( params[name+"Day"] ) == false ) {
        return null ;
    }
    var year = params[name+"Year"] ;
    var month = params[name+"Month"] ;
    var day = params[name+"Day"] ;
    return new Date( year,month-1,day ) ;
}

// 指定日付情報を、各パラメータに付加.
convertDateByMap = function( map,name,date ) {
    if( isNull( map ) || useString( name ) == false ||
        isNull( date ) || valueof( date ) != "date" ) {
        return false ;
    }
    map[name+"Year"] = date.getFullYear() ;
    map[name+"Month"] = date.getMonth()+1 ;
    map[name+"Day"] = date.getDate() ;
    return true ;
}


// 指定日付情報を、各パラメータに付加.
convertDateByParam = function( name,date ) {
    if( useString( name ) == false || isNull( date ) || valueof( date ) != "date" ) {
        return false ;
    }
    params[name+"Year"] = date.getFullYear() ;
    params[name+"Month"] = date.getMonth()+1 ;
    params[name+"Day"] = date.getDate() ;
    return true ;
}

////////////////////////////////////////////////////////////////////////////////
// Form内でのページバック機能.
////////////////////////////////////////////////////////////////////////////////
PageBack = function(){} ;

// backPage用パラメータをセット.
PageBack.pushTag = function() {
    if( __$type$script == "script" ) {
        return hiddenTag("_pageBackMode","next","_pageBackModeId") ;
    }
    return "" ;
}

// backPage条件であるかチェック.
PageBack.isPageBack = function() {
    if( params[ '_pageBackMode' ] == "back" ) {
        return true ;
    }
    return false ;
}

// backPage条件の場合、指定URLにフォワード.
PageBack.forward = function(url) {
    if( useString( url ) == true ) {
        if( params[ '_pageBackMode' ] == "back" ) {
            forwardMHTML( url ) ;
        }
    }
}

// ページバックJavascriptを生成.
PageBack.createPageBackScript= function(formName) {
    return new StrBuf().ad( "javascript:document.getElementById('_pageBackModeId').value='back';document." ).
        ad( formName ).ad( ".submit();" ).ts() ;
}

// ページバックリンクタグ.
PageBack.linkTag = function(view,formName) {
    if( useString( view ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return new StrBuf().ad( "<a href=\"" ).ad( PageBack.createPageBackScript(formName) ).ad( "\">" ).
            ad( view ).ad( "</a>" ).ts() ;
    }
    return "" ;
}

// ページバック開始リンクタグ.
PageBack.startLinkTag = function(formName) {
    if( __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return new StrBuf().ad( "<a href=\"" ).ad( PageBack.createPageBackScript(formName) ).ad( "\">" ).ts() ;
    }
    return "" ;
}

// ページバックボタンタグ.
PageBack.button = function(value,formName) {
    if( useString( value ) == true && __$type$script == "script" ) {
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        return button( value,new StrBuf().ad( "onclick=\"" ).
            ad( PageBack.createPageBackScript(formName) ).ad( "\"" ).ts() ) ;
    }
    return "" ;
}

// ページバックイメージボタンタグ.
PageBack.imgButton = function(name,src,formName,alt,border,width,height,cmode) {
    if( useString( src ) == true &&
        __$type$script == "script" ) {
        var time = imageCacheTime( cmode ) ;
        src = trim( src ) ;
        var x = toLowerCase( src ) ;
        var buf = new StrBuf().ad( "<input type=\"image\" src=\"" ) ;
        if( startsWith( x,"http://" ) || startsWith( x,"https://" ) ) {
            if( isNull( time ) ) {
                buf.ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        else {
            if( startsWith( src,"/" ) ) {
                src = src.substring( 1 ) ;
            }
            if( isNull( time ) ) {
                buf.ad( "/img/" ).ad( src ).ad( "\"" ) ;
            }
            else {
                buf.ad( "/img/" ).ad( src ).ad( "?" ).ad( time ).ad( "\"" ) ;
            }
        }
        if( useString( name ) ) {
            buf.ad( " name=\"" ).ad( name ).ad( "\"" ) ;
        }
        if( useString( alt ) ) {
            buf.ad( " alt=\"" ).ad( alt ).ad( "\"" ) ;
        }
        if( useString( border ) ) {
            buf.ad( " border=\"" ).ad( border ).ad( "\"" ) ;
        }
        if( isNull( width ) == false ) {
            buf.ad( " width=\"" ).ad( width ).ad( "\"" ) ;
        }
        if( isNull( height ) == false ) {
            buf.ad( " height=\"" ).ad( height ).ad( "\"" ) ;
        }
        if( useString( formName ) == false ) {
            formName = getFormNameByCurrentName() ;
        }
        buf.ad( " onclick=\"" ).ad( PageBack.createPageBackScript( formName ) ).ad( "\"" ) ;
        return buf.ad( ">" ).ts() ;
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// 2重押しを回避する機能.
////////////////////////////////////////////////////////////////////////////////
DoubleSend = function() {}

DoubleSend.sessionKey = "_double_send" ;
DoubleSend.valueSize = 56 ;

// ２重押しパラメータを設定.
DoubleSend.pushTag = function() {
    if( getConfig( "server","debug" ) != true ) {
        if( isSession() ) {
            var value = "" + org.maachang.util.RandomUtil.randomString( DoubleSend.valueSize,true,true,true ) ;
            return hiddenTag( DoubleSend.sessionKey,value ) ;
        }
    }
    return "" ;
}

// ２重押しされたかチェック.
DoubleSend.isDoubleSend = function() {
    if( getConfig( "server","debug" ) != true ) {
        if( isSession() ) {
            var value = getSession( DoubleSend.sessionKey ) ;
            if( useString( params[DoubleSend.sessionKey] ) == true ) {
                if( params[DoubleSend.sessionKey] == value ) {
                    return true ;
                }
                putSession( DoubleSend.sessionKey,params[DoubleSend.sessionKey] ) ;
                return false ;
            }
            else {
                return false ;
            }
        }
    }
    return false ;
}

////////////////////////////////////////////////////////////////////////////////
// マスターキャッシュ対応タグ.
////////////////////////////////////////////////////////////////////////////////
MasterTag = function(){}

// 対象パラメータ名のマスター内容を出力.
MasterTag.viewListToParams = function(name,master,startPos,endPos) {
    if( isNull( name ) || isNull( master ) ) {
        return "" ;
    }
    var qu = _$script$query.get( name ) ;
    if( isNull( qu ) ) {
        return "" ;
    }
    if( useString( startPos ) == false ) {
        startPos = "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    var clsName = className( qu ) ;
    if( valueof( qu ) == 'object' && className( qu ) == "ArrayList" ) {
        var buf = new StrBuf() ;
        len = qu.size() ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                buf.ad( endPos ) ;
            }
            var num = parseInt(qu.get( i )) ;
            if( num <= -1 || master.length <= num ) {
                continue ;
            }
            buf.ad( startPos ).ad( convertViewHtml( master[ num ].name ) ) ;
        }
        return buf.ts() ;
    }
    else {
        if( isNumeric( qu ) == false ) {
            return "" ;
        }
        var num = parseInt(qu) ;
        if( num <= -1 || master.length <= num ) {
            return "" ;
        }
        return new StrBuf().ad( startPos ).ad( convertViewHtml( master[ num ].name ) ).ad( endPos ).ts() ;
    }
}

// 指定CSVのマスター内容を出力.
MasterTag.viewListToCsv = function(csv,master,startPos,endPos,cut) {
    if( isNull( csv ) || isNull( master ) ) {
        return "" ;
    }
    if( useString( startPos ) == false ) {
        startPos = "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    csv = "" + csv ;
    var qu ;
    if( useString( cut ) == false ) {
        qu = csv.split('|') ;
    }
    else {
        qu = csv.split( cut ) ;
    }
    if( qu.length == 1 ) {
        if( isNumeric( qu[ 0 ] ) == false ) {
            return "" ;
        }
        var num = parseInt(qu[ 0 ]) ;
        if( num <= -1 || master.length <= num ) {
            return "" ;
        }
        return new StrBuf().ad( startPos ).ad( convertViewHtml( master[ num ].name ) ).ad( endPos ).ts() ;
    }
    else {
        var buf = new StrBuf() ;
        var len = qu.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                buf.ad( endPos ) ;
            }
            var num = parseInt(qu[ i ]) ;
            if( num <= -1 || master.length <= num ) {
                continue ;
            }
            buf.ad( startPos ).ad( convertViewHtml( master[ num ].name ) ) ;
        }
        return buf.ts() ;
    }
}

// 指定パラメータ内容のマスター内容を出力.
MasterTag.viewToParams = function(name,master) {
    if( isNull( name ) || isNull( master ) ) {
        return "" ;
    }
    var id = _$script$query.get( name ) ;
    if( isNull( id ) || isNumeric( id ) == false ) {
        return "" ;
    }
    id = parseInt( id ) ;
    if( id <= 0 || id > master.length ) {
        return "" ;
    }
    return master[ id ].name ;
}

// 指定IDのマスター内容を出力.
MasterTag.viewToId = function(id,master) {
    if( isNull( id ) || isNull( master ) || isNumeric( id ) == false ) {
        return "" ;
    }
    id = parseInt( id ) ;
    if( id <= 0 || id > master.length ) {
        return "" ;
    }
    return master[ id ].name ;
}

// マスターデータを用いて、Selectタグを生成.
MasterTag.selectTag = function(name,master,viewColum,defSelect,etc) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    var id = name + "Id" ;
    var buf = new StrBuf().ad( "<select name=\"" ).ad( name ).ad( "\" id=\"" ).ad( id ).ad( "\"" ) ;
    etcTag( etc,buf ) ;
    buf.ad( " >\n" ) ;
    if( useString( defSelect ) ) {
        if( defSelect != "_not" ) {
            buf.ad( "    <option value=\"0\">" ).ad( defSelect ).ad( "\n" ) ;
        }
    }
    else {
        buf.ad( "    <option value=\"\">選択してください\n" ) ;
    }
    if( valueof( master ) == 'map' ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var target = _$script$query.get(name) ;
        if( isNull( target ) == true ) {
            for( var i = 0 ; i < len ; i ++ ) {
                if( viewColum != null ) {
                    buf.ad( "    <option value=\"" ).ad( master[mapKey[i]].id ).
                        ad( "\">" ).ad( convertViewHtml(master[mapKey[i]][viewColum]) ).ad( "\n" ) ;
                }
                else {
                    buf.ad( "    <option value=\"" ).ad( master[mapKey[i]].id ).ad( "\">" ).
                        ad( convertViewHtml(master[mapKey[i]].name) ).ad( "\n" ) ;
                }
            }
        }
        else {
            for( var i = 0 ; i < len ; i ++ ) {
                buf.ad( "    <option value=\"" ).ad( master[mapKey[i]].id ).ad( "\" " ) ;
                if( master[mapKey[i]].id == target ) {
                    buf.ad( "selected " ) ;
                }
                if( viewColum != null ) {
                    buf.ad( ">" ).ad( convertViewHtml(master[mapKey[i]][viewColum]) ).ad( "\n" ) ;
                }
                else {
                    buf.ad( ">" ).ad( convertViewHtml(master[mapKey[i]].name) ).ad( "\n" ) ;
                }
            }
        }
    }
    else {
        var len = master.length ;
        var target = _$script$query.get(name) ;
        if( isNull( target ) == true ) {
            for( var i = 0 ; i < len ; i ++ ) {
                if( viewColum != null ) {
                    buf.ad( "    <option value=\"" ).ad( master[i].id ).ad( "\">" ).
                        ad( convertViewHtml(master[i][viewColum]) ).ad( "\n" ) ;
                }
                else {
                    buf.ad( "    <option value=\"" ).ad( master[i].id ).ad( "\">" ).
                        ad( convertViewHtml(master[i].name) ).ad( "\n" ) ;
                }
            }
        }
        else {
            for( var i = 0 ; i < len ; i ++ ) {
                buf.ad( "    <option value=\"" ).ad( master[i].id ).ad( "\" " ) ;
                if( master[i].id == target ) {
                    buf.ad( "selected " ) ;
                }
                if( viewColum != null ) {
                    buf.ad( ">" ).ad( convertViewHtml(master[i][viewColum]) ).ad( "\n" ) ;
                }
                else {
                    buf.ad( ">" ).ad( convertViewHtml(master[i].name) ).ad( "\n" ) ;
                }
            }
        }
    }
    return buf.ad( "</select>" ).ts() ;
}

// マスターデータを用いて、チェックボックスタグを生成.
MasterTag.checkBoxTag = function( name,master,row,endPos,viewColum,etc ) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( row ) == false || row <= 0 ) {
        row = 0 ;
    }
    var buf = new StrBuf() ;
    if( valueof( master ) == "map" ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                buf.ad( "\r\n" ) ;
            }
            buf.ad( checkBoxTag( name,master[mapKey[i]].id,null,null,etc ) ) ;
            if( viewColum != null ) {
                buf.ad( master[mapKey[i]][viewColum] ) ;
            }
            else {
                buf.ad( master[mapKey[i]].name ) ;
            }
            if( row <= cnt ) {
                buf.ad( endPos ) ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    else {
        var len = master.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                buf.ad( "\r\n" ) ;
            }
            buf.ad( checkBoxTag( name,master[i].id,null,null,etc ) ) ;
            if( viewColum != null ) {
                buf.ad( master[i][viewColum] ) ;
            }
            else {
                buf.ad( master[i].name ) ;
            }
            if( row <= cnt ) {
                buf.ad( endPos ) ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    if( endFlg == false ) {
        buf.ad( endPos ) ;
    }
    return buf.ts() ;
}

// マスターデータを用いて、ラジオボタンタグを生成.
MasterTag.radioTag = function( name,master,row,endPos,viewColum,etc ) {
    if( isNull( viewColum ) ) {
        viewColum = null ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( row ) == false || row <= 0 ) {
        row = 0 ;
    }
    var buf = new StrBuf() ;
    if( valueof( master ) == "map" ) {
        var mapKey = keyMapSort( master ) ;
        var len = mapKey.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                buf.ad( "\r\n" ) ;
            }
            buf.ad( radioTag( name,master[mapKey[i]].id,null,null,etc ) ) ;
            if( viewColum != null ) {
                buf.ad( master[mapKey[i]][viewColum] ) ;
            }
            else {
                buf.ad( master[mapKey[i]].name ) ;
            }
            if( row <= cnt ) {
                buf.ad( endPos ) ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    else {
        var len = master.length ;
        var cnt = 0 ;
        var endFlg = false ;
        for( var i = 0 ; i < len ; i ++ ) {
            cnt ++ ;
            if( i != 0 ) {
                buf.ad( "\r\n" ) ;
            }
            buf.ad( radioTag( name,master[i].id,null,null,etc ) ) ;
            if( viewColum != null ) {
                buf.ad( master[i][viewColum] ) ;
            }
            else {
                buf.ad( master[i].name ) ;
            }
            if( row <= cnt ) {
                buf.ad( endPos ) ;
                cnt = 0 ;
                endFlg = true ;
            }
            else {
                endFlg = false ;
            }
        }
    }
    if( endFlg == false ) {
        buf.ad( endPos ) ;
    }
    return buf.ts() ;
}

////////////////////////////////////////////////////////////////////////////////
// Yes/Noタグ.
////////////////////////////////////////////////////////////////////////////////

YesNoTag = function(){}

// Yes,No表示.
YesNoTag.view = function( id,yes,no ) {
    if( isNull( id ) || isNumeric( id ) == false ) {
        return "" ;
    }
    if( id == "1" ) {
        return no ;
    }
    else if( id == "2" ) {
        return yes ;
    }
    return "" ;
}

// Yes,No-Param表示.
YesNoTag.viewParam = function( name,yes,no ) {
    if( useString( name ) == false ) {
        return "" ;
    }
    var v = _$script$query.get(name) ;
    if( v == "1" ) {
        return no ;
    }
    else if( v == "2" ) {
        return yes ;
    }
    return "" ;
}

// 有効・無効selectタグを生成.
YesNoTag.selectTag = function(name,yes,no) {
    if( isNull( name ) ) {
        return "" ;
    }
    if( useString( yes ) == false || useString( no ) == false ) {
        yes = "Yes" ;
        no = "No" ;
    }
    return selectTag( name,["","選択してください","2",yes,"1",no] ) ;
}

// Yes,Noラジオボタン.
YesNoTag.radioTag = function( name,yes,no,endPos ) {
    if( isNull( name ) ) {
        return "" ;
    }
    if( useString( endPos ) == false ) {
        endPos = "" ;
    }
    if( useString( yes ) == false || useString( no ) == false ) {
        yes = "Yes" ;
        no = "No" ;
    }
    return new StrBuf().ad( radioTag( name,"2" ) ).
        ad( yes ).ad( endPos ).
        ad( radioTag( name,"1" ) ).
        ad( no ).ad( endPos ).ts() ;
}

