package org.maachang.dbm.engine ;

import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

/**
 * 指定キーでロック処理.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2Lock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 1L ;
    
    /**
     * ロック名群.
     */
    private final Set<Integer> manager = new ConcurrentSkipListSet<Integer>() ;

    
    /**
     * コンストラクタ.
     */
    public M2Lock() {
    }
    
    /**
     * 指定名でロック.
     * @param code Hashコードを設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( int code ) throws InterruptedException {
        Integer key = new Integer( code & M2RawHash.MASK_HASH ) ;
        for( ;; ) {
            if( manager.contains( key ) == false ) {
                manager.add( key ) ;
                break ;
            }
            Thread.sleep( SLEEP_TIME ) ;
        }
    }
    
    /**
     * 指定名でアンロック.
     * @param code Hashコードを設定します.
     */
    public void unlock( int code ) {
        manager.remove( new Integer( code & M2RawHash.MASK_HASH ) ) ;
    }
}
