package org.maachang.dbm.engine ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * MDbm定数初期化処理.
 * 
 * @version 2008/05/24
 * @author masahito suzuki
 * @since MaachangDBM 1.0E
 */
public class MDbmEnv {
    
    /**
     * Hash数.
     */
    public static final int HASH ;
    
    /**
     * １セクタファイルで扱える最大数.
     */
    public static final int ONE_SECTOR_BY_SECTOR_SIZE ;
    
    /**
     * 初期化処理.
     */
    static {
        
        // ログ出力ファイル条件.
        Log logOut = LogFactory.getLog( MDbmEnv.class ) ;
        
        // バージョンを表示.
        if( MDbmDefine.OUT_MODE == true ) {
            if( logOut.isDebugEnabled() ) {
                logOut.debug( "## MDbm version:" + MDbmDefine.VERSION ) ;
            }
        }
        
        // データ受け取り一時条件.
        int n ;
        
        //////////////////////////////////////////////////////////////
        // Hash設定.
        //////////////////////////////////////////////////////////////
        n = MDbmDefine.DEF_HASH ;
        if( System.getProperty( MDbmDefine.HASH_PROPERTY ) != null ) {
            try {
                n = Integer.parseInt( System.getProperty( MDbmDefine.HASH_PROPERTY ) ) ;
                if( n >= MDbmDefine.MAX_HASH ) {
                    n = MDbmDefine.MAX_HASH ;
                }
                else if( n <= MDbmDefine.MIN_HASH ) {
                    n = MDbmDefine.MIN_HASH ;
                }
            } catch( Exception e ) {
                n = MDbmDefine.DEF_HASH ;
            }
        }
        int hashSize = 0x000fffff ;
        switch( n ) {
            case 8 : hashSize = 0x000000ff ; break ;
            case 9 : hashSize = 0x000001ff ; break ;
            case 10 : hashSize = 0x000003ff ; break ;
            case 11 : hashSize = 0x000007ff ; break ;
            case 12 : hashSize = 0x00000fff ; break ;
            case 13 : hashSize = 0x00001fff ; break ;
            case 14 : hashSize = 0x00003fff ; break ;
            case 15 : hashSize = 0x00007fff ; break ;
            case 16 : hashSize = 0x0000ffff ; break ;
            case 17 : hashSize = 0x0001ffff ; break ;
            case 18 : hashSize = 0x0003ffff ; break ;
            case 19 : hashSize = 0x0007ffff ; break ;
            case 20 : hashSize = 0x000fffff ; break ;
            case 21 : hashSize = 0x001fffff ; break ;
            case 22 : hashSize = 0x003fffff ; break ;
            case 23 : hashSize = 0x007fffff ; break ;
            case 24 : hashSize = 0x00ffffff ; break ;
            case 25 : hashSize = 0x01ffffff ; break ;
            case 26 : hashSize = 0x03ffffff ; break ;
            case 27 : hashSize = 0x07ffffff ; break ;
            case 28 : hashSize = 0x0fffffff ; break ;
            case 29 : hashSize = 0x1fffffff ; break ;
            case 30 : hashSize = 0x3fffffff ; break ;
            case 31 : hashSize = 0x7fffffff ; break ;
        }
        HASH = hashSize + 1 ;
        if( MDbmDefine.OUT_MODE == true ) {
            if( logOut.isDebugEnabled() ) {
                logOut.debug( "## MDbmEnv.HASH:" + ( hashSize + 1 ) ) ;
            }
        }
        
        // １セクタファイルで扱える最大数.
        n = MDbmDefine.DEF_ONE_FILE_SECTOR ;
        if( System.getProperty( MDbmDefine.ONE_FILE_SECTOR_PROPERTY ) != null ) {
            try {
                n = Integer.parseInt( System.getProperty( MDbmDefine.ONE_FILE_SECTOR_PROPERTY ) ) ;
                if( n >= MDbmDefine.MAX_ONE_FILE_SECTOR ) {
                    n = MDbmDefine.MAX_ONE_FILE_SECTOR ;
                }
                else if( n <= MDbmDefine.MIN_ONE_FILE_SECTOR ) {
                    n = MDbmDefine.MIN_ONE_FILE_SECTOR ;
                }
            } catch( Exception e ) {
                n = MDbmDefine.DEF_ONE_FILE_SECTOR ;
            }
        }
        n = ( int )( n / MDbmDefine.MIN_ONE_FILE_SECTOR ) * MDbmDefine.MIN_ONE_FILE_SECTOR ;
        if( n <= MDbmDefine.MIN_ONE_FILE_SECTOR ) {
            n = MDbmDefine.MIN_ONE_FILE_SECTOR ;
        }
        ONE_SECTOR_BY_SECTOR_SIZE = n ;
        if( MDbmDefine.OUT_MODE == true ) {
            if( logOut.isDebugEnabled() ) {
                logOut.debug( "## MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE:" + n ) ;
            }
        }
        
    }
}

